/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.processus;

import java.sql.Date;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.PageLibre;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.FicheUnivMgr;

// TODO: Auto-generated Javadoc
/**
 * processus saisie PageLibre.
 */
public class TraitementPageLibre extends SaisieFiche {

	/** The Constant ECRAN_PRINCIPAL. */
	private static final String ECRAN_PRINCIPAL = "PRINCIPAL";

	/** The page libre. */
	PageLibre pageLibre = null;

	/**
	 * processus saisie PageLibre.
	 *
	 * @param ciu
	 *            com.jsbsoft.jtf.core.InfoBean
	 */
	public TraitementPageLibre(final InfoBean ciu) {
		super(ciu);
	}

	/**
	 * Affichage de la liste des PageLibres.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void preparerLISTE() throws Exception {}

	/**
	 * Affichage de l'écran de saisie d'un PageLibre.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void preparerPRINCIPAL() throws Exception {
		infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(getLocale()));
		ecranLogique = ECRAN_PRINCIPAL;
	}

	/**
	 * Affichage de l'écran des critères de recherche d'un PageLibre.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void preparerRECHERCHE() throws Exception {}

	/**
	 * Abandon de l'activité: on libère les ressources.
	 *
	 * @return true, if traiter action
	 *
	 * @throws Exception
	 *             the exception
	 */
	/**
	 * Point d'entrée du processus
	 */
	@Override
	public boolean traiterAction() throws Exception {
		infoBean.set("CODE_OBJET", "0016");
		etat = EN_COURS;
		pageLibre = new PageLibre();
		pageLibre.setCtx(this);
		pageLibre.init();
		traiterActionParDefaut(pageLibre);
		if (ecranLogique.equals(ECRAN_CONFIRMATION)) {
			traiterCONFIRMATION();
		}
		//placer l'état dans le composant d'infoBean
		infoBean.setEcranLogique(ecranLogique);
		infoBean.set("NOM_ONGLET", "pagelibre");
		// On continue si on n'est pas à la FIN !!!
		return (etat == FIN);
	}

	/**
	 * Traitement associé à l'écran de saisie des critères.
	 *
	 * @throws Exception
	 *             the exception
	 */
	protected void traiterLISTE() throws Exception {}

	/**
	 * Gestion de l'écran de saisie d'un PageLibre.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void traiterPRINCIPAL() throws Exception {
		if (action.equals(InfoBean.ACTION_ANNULER)) {
			ecranLogique = "FIN_TOOLBOX";
		} else if (action.equals(InfoBean.ACTION_ENREGISTRER)) {
			pageLibre.init();
			/* Données saisissables uniquement en création */
			pageLibre.setLangue((String) infoBean.get("LANGUE"));
			/***********************************************/
			/* Partie contenu                              */
			/***********************************************/
			pageLibre.setTitre((String) infoBean.get("TITRE"));
			pageLibre.setCodeRubrique((String) infoBean.get("CODE_RUBRIQUE"));
			pageLibre.setCodeRedacteur((String) getGp().getSessionUtilisateur().getInfos().get(SessionUtilisateur.CODE));
			// RP20070904 ajout de la structure de l'utilisateur
			final SessionUtilisateur sessionUtilisateur = getGp().getSessionUtilisateur();
			final AutorisationBean autorisations = (AutorisationBean) sessionUtilisateur.getInfos().get(SessionUtilisateur.AUTORISATIONS);
			final String structureUtilisateur = autorisations.getCodeStructure();
			if (structureUtilisateur.length() > 0) {
				// On regarde si l'autorisation est compatible avec la rubrique
				if (autorisations.possedePermission(new PermissionBean("FICHE", ReferentielObjets.getCodeObjetParClasse(pageLibre.getClass().getName()), "C"), new Perimetre(
					structureUtilisateur, pageLibre.getCodeRubrique(), "*", "*", ""))) {
					pageLibre.setCodeRattachement(structureUtilisateur);
				}
			}
			/*************************************/
			/* Appel traitement général          */
			/*************************************/
			pageLibre.setEtatObjet("0001");
			final Date date = new Date(System.currentTimeMillis());
			pageLibre.setDateModification(date);
			FicheUnivMgr.enregistrer(true, pageLibre); // document.enregistrer(true);
			// Lecture métatag
			final Metatag meta = FicheUnivMgr.creerMeta(pageLibre);
			meta.addHistorique(Metatag.HISTORIQUE_CREATION, (String) this.getGp().getSessionUtilisateur().getInfos().get(SessionUtilisateur.CODE), pageLibre.getEtatObjet());
			FicheUnivMgr.enregistrerMeta(meta);
			infoBean.set("CODE", pageLibre.getCode());
			preparerCONFIRMATION();
		}
	}

	/**
	 * Traitement associé à l'écran de saisie des critères.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void traiterRECHERCHE() throws Exception {}

	/** The Constant ECRAN_CONFIRMATION. */
	private static final String ECRAN_CONFIRMATION = "CONFIRMATION";

	/**
	 * Preparer confirmation.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void preparerCONFIRMATION() throws Exception {
		ecranLogique = ECRAN_CONFIRMATION;
	}

	/**
	 * Traiter confirmation.
	 *
	 * @throws Exception
	 *             the exception
	 */
	protected void traiterCONFIRMATION() throws Exception {
		if (action.equals(InfoBean.ACTION_ANNULER)) {
			ecranLogique = "FIN_TOOLBOX";
		}
	}
}
