/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.sgbd;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;

import com.jsbsoft.jtf.database.OMContext;

// TODO: Auto-generated Javadoc
/**
 * The Class ChangementmotpasseDB.
 */
public class ChangementmotpasseDB {

	/** The qualifier. */
	protected String qualifier = null;

	/** The _stmt. */
	private java.sql.PreparedStatement _stmt = null;

	/** The _rs. */
	private ResultSet rs = null;

	/** The ctx. */
	protected OMContext ctx = null;

	/** The id changement mot passe. */
	private Long idChangementMotPasse = null;

	/** The code. */
	private String code = null;

	/** The email. */
	private String email = null;

	/** The id. */
	private String id = null;

	/** The date demande. */
	private java.sql.Date dateDemande = null;

	/**
	 * Instantiates a new changementmotpasse db.
	 */
	public ChangementmotpasseDB() {}

	/**
	 * Adds the.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void add() throws Exception {
		ResultSet rs = null;
		try {
			_stmt = getConnection().prepareStatement(" INSERT INTO " + qualifier + "CHANGEMENTMOTPASSE (ID_CHANGEMENT_MOT_PASSE  ,   CODE  ,   EMAIL  ,   ID  ,   DATE_DEMANDE  )              VALUES (?  ,?  ,?  ,?  ,?  ) ", Statement.RETURN_GENERATED_KEYS);
			_stmt.setObject(1, getIdChangementMotPasse(), Types.BIGINT);
			_stmt.setObject(2, getCode(), Types.VARCHAR);
			_stmt.setObject(3, getEmail(), Types.VARCHAR);
			_stmt.setObject(4, getId(), Types.VARCHAR);
			_stmt.setObject(5, getDateDemande(), Types.DATE);
			final int rowsAffected = _stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			}
			if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
			rs = _stmt.getGeneratedKeys();
			rs.next();
			setIdChangementMotPasse(rs.getLong(1));
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD add() " + exc);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (_stmt != null) {
				_stmt.close();
				_stmt = null;
			}
		}
	}

	/**
	 * Delete.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void delete() throws Exception {
		try {
			_stmt = getConnection().prepareStatement("DELETE FROM " + qualifier + "CHANGEMENTMOTPASSE WHERE " + "             ID_CHANGEMENT_MOT_PASSE = ? ");
			// put parameters into statement
			_stmt.setObject(1, getIdChangementMotPasse(), Types.BIGINT);
			final int rowsAffected = _stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			}
			if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD delete() " + exc);
		} finally {
			if (_stmt != null) {
				_stmt.close();
			}
		}
	}

	/**
	 * Gets the connection.
	 * 
	 * @return the connection
	 */
	private Connection getConnection() {
		return ctx.getConnection();
	}

	/**
	 * Gets the id changement mot passe.
	 * 
	 * @return the id changement mot passe
	 */
	public Long getIdChangementMotPasse() {
		return idChangementMotPasse;
	}

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Gets the email.
	 * 
	 * @return the email
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * Gets the id.
	 * 
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Gets the date demande.
	 * 
	 * @return the date demande
	 */
	public java.sql.Date getDateDemande() {
		return dateDemande;
	}

	/**
	 * Gets the sQL base query.
	 * 
	 * @return the sQL base query
	 */
	public String getSQLBaseQuery() {
		return "SELECT " + "T1.ID_CHANGEMENT_MOT_PASSE ,  " + "T1.CODE ,  " + "T1.EMAIL ,  " + "T1.ID ,  " + "T1.DATE_DEMANDE " + "         FROM " + qualifier + "CHANGEMENTMOTPASSE T1 ";
	}

	/**
	 * Next item.
	 * 
	 * @return true, if successful
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public boolean nextItem() throws Exception {
		boolean res = false;
		try {
			if (rs.next()) {
				retrieveFromRS(rs);
				res = true;
			} else {
				try {
					rs.close();
				} finally {
					rs = null;
				}
			}
		} catch (final Exception e) {
			throw new Exception("ERROR_IN_METHOD nextItem() " + e);
		}
		return res;
	}

	/**
	 * R?cup?ration d'une ligne de la base de donn?es.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void retrieve() throws Exception {
		ResultSet rs = null;
		try {
			_stmt = getConnection().prepareStatement(
				"SELECT " + "             ID_CHANGEMENT_MOT_PASSE," + "             CODE," + "             EMAIL," + "             ID," + "             DATE_DEMANDE" + "         FROM " + qualifier + "CHANGEMENTMOTPASSE WHERE " + "             ID_CHANGEMENT_MOT_PASSE = ? ");
			// put parameters into statement
			_stmt.setObject(1, getIdChangementMotPasse(), Types.BIGINT);
			rs = _stmt.executeQuery();
			if (!rs.next()) {
				throw new Exception("retrieve  : METHOD_NO_RESULTS");
			}
			// get output from result set
			retrieveFromRS(rs);
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD retrieve() " + exc);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (_stmt != null) {
				_stmt.close();
			}
		}
	}

	/**
	 * Retrieve from rs.
	 * 
	 * @param _rs
	 *            the _rs
	 * 
	 * @throws Exception
	 *             the exception
	 */
	private void retrieveFromRS(final ResultSet _rs) throws Exception {
		try {
			// get output from result set
			setIdChangementMotPasse(new Long(_rs.getLong(1)));
			setCode(_rs.getString(2));
			setEmail(_rs.getString(3));
			setId(_rs.getString(4));
			setDateDemande(_rs.getDate(5));
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD retrieveFromRS() " + exc);
		}
	}

	/**
	 * Select.
	 * 
	 * @param sqlSuffix
	 *            the sql suffix
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public int select(String sqlSuffix) throws Exception {
		int count = 0;
		try {
			if (sqlSuffix == null) {
				sqlSuffix = "";
			}
			String query = "SELECT COUNT(*)   FROM " + qualifier + "CHANGEMENTMOTPASSE T1 " + sqlSuffix;
			/* r?cup?ration nombre de lignes */
			_stmt = getConnection().prepareStatement(query);
			rs = _stmt.executeQuery(query);
			rs.next();
			count = rs.getInt(1);
			/* ?x?cution requete */
			query = getSQLBaseQuery() + sqlSuffix;
			_stmt = getConnection().prepareStatement(getSQLBaseQuery() + sqlSuffix);
			rs = _stmt.executeQuery();
		} catch (final SQLException exc) {
			throw new Exception("SELECT_FAILED " + exc);
		} finally {
			_stmt = null;
		}
		return count;
	}

	/**
	 * Sets the id changement mot passe.
	 * 
	 * @param _idChangementMotPasse
	 *            the new id changement mot passe
	 */
	public void setIdChangementMotPasse(final Long _idChangementMotPasse) {
		idChangementMotPasse = _idChangementMotPasse;
	}

	/**
	 * Sets the code.
	 * 
	 * @param _code
	 *            the new code
	 */
	public void setCode(final String _code) {
		code = _code;
	}

	/**
	 * Sets the email.
	 * 
	 * @param _email
	 *            the new email
	 */
	public void setEmail(final String _email) {
		email = _email;
	}

	/**
	 * Sets the id.
	 * 
	 * @param _id
	 *            the new id
	 */
	public void setId(final String _id) {
		id = _id;
	}

	/**
	 * Sets the date demande.
	 * 
	 * @param _dateDemande
	 *            the new date demande
	 */
	public void setDateDemande(final java.sql.Date _dateDemande) {
		dateDemande = _dateDemande;
	}

	/**
	 * Sets the param.
	 * 
	 * @param _ctx
	 *            the _ctx
	 * @param _qualifier
	 *            the _qualifier
	 */
	public void setParam(final OMContext _ctx, final String _qualifier) {
		ctx = _ctx;
		qualifier = "";
		if (_qualifier.equals("") == false) {
			if (_qualifier.substring(_qualifier.length() - 1).equals(".") == false) {
				qualifier = _qualifier + ".";
			} else {
				qualifier = _qualifier;
			}
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(".");
	}

	//----------------------------------------------------------------
	// Display methods
	//----------------------------------------------------------------
	/**
	 * To string.
	 * 
	 * @param aSeparator
	 *            the a separator
	 * 
	 * @return the string
	 */
	public String toString(final String aSeparator) {
		return (String.valueOf("" + aSeparator + getIdChangementMotPasse() + aSeparator + getCode() + aSeparator + getEmail() + aSeparator + getId() + aSeparator + getDateDemande()));
	}

	/**
	 * Mise ? jour d'une ligne de la base de donn?es.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void update() throws Exception {
		try {
			_stmt = getConnection().prepareStatement(
				"UPDATE " + qualifier + "CHANGEMENTMOTPASSE SET " + "ID_CHANGEMENT_MOT_PASSE = ?, " + "CODE = ?, " + "EMAIL = ?, " + "ID = ?, " + "DATE_DEMANDE = ? " + "         WHERE " + "             ID_CHANGEMENT_MOT_PASSE = ? ");
			// put parameters into statement
			_stmt.setObject(1, getIdChangementMotPasse(), Types.BIGINT);
			_stmt.setObject(2, getCode(), Types.VARCHAR);
			_stmt.setObject(3, getEmail(), Types.VARCHAR);
			_stmt.setObject(4, getId(), Types.VARCHAR);
			_stmt.setObject(5, getDateDemande(), Types.DATE);
			_stmt.setObject(6, getIdChangementMotPasse(), Types.BIGINT);
			_stmt.executeUpdate();
			_stmt.close();
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD update() " + exc);
		} finally {
			if (_stmt != null) {
				_stmt.close();
			}
		}
	}

	/**
	 * Sets the ctx.
	 * 
	 * @param _ctx
	 *            the new ctx
	 */
	public void setCtx(final OMContext _ctx) {
		setParam(_ctx, "");
	}
}
