/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.sgbd;

// TODO: Auto-generated Javadoc
/**
 * Interface décrivant l'objet DB d'une fiche K-Portal.
 */
public interface FicheUnivDB {

	/**
	 * Adds the.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void add() throws Exception;

	/**
	 * Delete.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void delete() throws Exception;

	/**
	 * Update.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void update() throws Exception;

	/**
	 * Select.
	 * 
	 * @param requete
	 *            the requete
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public int select(String requete) throws Exception;

	/**
	 * Retrieve.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void retrieve() throws Exception;

	/**
	 * Next item.
	 * 
	 * @return true, if successful
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public boolean nextItem() throws Exception;
}
