/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.sgbd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Types;

import com.jsbsoft.jtf.database.OMContext;

// TODO: Auto-generated Javadoc
/**
 * The Class MailingDB.
 */
public class MailingDB {

	//TODO - Ajouter une colonne en base pour stocker le type de newsletter lors de l'envoi (réplication de la colonne publicinterne) et une colonne pour le stockage de la date d'envoi.
	// => A des impacts dans SaisieModeleMail.java (preparerListeHistoriqueDesEnvois et preparerARCHIVE), dans ModeleMailThread.java (constructeur, etc...)
	
	
	
	/** The qualifier. */
	protected String qualifier = null;

	/** The _stmt. */
	private java.sql.PreparedStatement _stmt = null;

	/** The _rs. */
	private ResultSet _rs = null;

	/** The ctx. */
	protected OMContext ctx = null;

	/** The id mailing. */
	private Long idMailing = null;

	/** The email. */
	private String email = null;

	/** The code utilisateur. */
	private String codeUtilisateur = null;

	/** The nom utilisateur. */
	private String nomUtilisateur = null;

	/** The reply to. */
	private String replyTo = null;

	/** The objet. */
	private String objet = null;

	/** The type mime. */
	private String typeMime = null;

	/** The message. */
	private String message = null;

	/** The fichier. */
	private String fichier = null;

	/** The nom fichier. */
	private String nomFichier = null;

	/** The etat. */
	private String etat = null;

	/** The error message. */
	private String errorMessage = null;

	/** The id newsletter. */
	private String idNewsletter = null;

	/** The date purge. */
	private java.sql.Date datePurge = null;

	/**
	 * le type (issu du type de la newsletter)
	 */
	private String type = null;

	/**
	 * La date de création du mailing
	 */
	private Timestamp dateCreation = null;

	/**
	 * Instantiates a new mailing db.
	 */
	public MailingDB() {}

	/**
	 * Adds the.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void add() throws Exception {
		ResultSet rs = null;
		try {
			_stmt = getConnection().prepareStatement(" INSERT INTO " + qualifier + "MAILING (ID_MAILING  ,   EMAIL  ,   CODE_UTILISATEUR  ,   NOM_UTILISATEUR  ,   REPLY_TO  ,   OBJET  ,   TYPE_MIME  ,   MESSAGE  ,   FICHIER  ,   NOM_FICHIER  ,   ETAT  ,   ERROR_MESSAGE  ,   ID_NEWSLETTER  ,   DATE_PURGE  ,   DATE_CREATION  ,   TYPE  )              VALUES (?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ) ", Statement.RETURN_GENERATED_KEYS);
			_stmt.setObject(1, getIdMailing(), Types.BIGINT);
			_stmt.setObject(2, getEmail(), Types.VARCHAR);
			_stmt.setObject(3, getCodeUtilisateur(), Types.VARCHAR);
			_stmt.setObject(4, getNomUtilisateur(), Types.VARCHAR);
			_stmt.setObject(5, getReplyTo(), Types.VARCHAR);
			_stmt.setObject(6, getObjet(), Types.VARCHAR);
			_stmt.setObject(7, getTypeMime(), Types.VARCHAR);
			_stmt.setObject(8, getMessage(), Types.LONGVARCHAR);
			_stmt.setObject(9, getFichier(), Types.VARCHAR);
			_stmt.setObject(10, getNomFichier(), Types.VARCHAR);
			_stmt.setObject(11, getEtat(), Types.VARCHAR);
			_stmt.setObject(12, getErrorMessage(), Types.VARCHAR);
			_stmt.setObject(13, getIdNewsletter(), Types.VARCHAR);
			_stmt.setObject(14, getDatePurge(), Types.DATE);
			_stmt.setObject(15, getDateCreation(), Types.TIMESTAMP);
			_stmt.setObject(16, getType(), Types.VARCHAR);
			final int rowsAffected = _stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			}
			if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
			rs = _stmt.getGeneratedKeys();
			rs.next();
			setIdMailing(rs.getLong(1));
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD add() " + exc);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (_stmt != null) {
				_stmt.close();
				_stmt = null;
			}
		}
	}

	/**
	 * Delete.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void delete() throws Exception {
		try {
			_stmt = getConnection().prepareStatement("DELETE FROM " + qualifier + "MAILING WHERE " + "             ID_MAILING = ? ");
			// put parameters into statement
			_stmt.setObject(1, getIdMailing(), Types.BIGINT);
			final int rowsAffected = _stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			}
			if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD delete() " + exc);
		} finally {
			if (_stmt != null) {
				_stmt.close();
				_stmt = null;
			}
		}
	}

	/**
	 * Gets the connection.
	 * 
	 * @return the connection
	 */
	private Connection getConnection() {
		return ctx.getConnection();
	}

	/**
	 * Gets the id mailing.
	 * 
	 * @return the id mailing
	 */
	public Long getIdMailing() {
		return idMailing;
	}

	/**
	 * Gets the email.
	 * 
	 * @return the email
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * Gets the code utilisateur.
	 * 
	 * @return the code utilisateur
	 */
	public String getCodeUtilisateur() {
		return codeUtilisateur;
	}

	/**
	 * Gets the nom utilisateur.
	 * 
	 * @return the nom utilisateur
	 */
	public String getNomUtilisateur() {
		return nomUtilisateur;
	}

	/**
	 * Gets the reply to.
	 * 
	 * @return the reply to
	 */
	public String getReplyTo() {
		return replyTo;
	}

	/**
	 * Gets the objet.
	 * 
	 * @return the objet
	 */
	public String getObjet() {
		return objet;
	}

	/**
	 * Gets the type mime.
	 * 
	 * @return the type mime
	 */
	public String getTypeMime() {
		return typeMime;
	}

	/**
	 * Gets the message.
	 * 
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * Gets the fichier.
	 * 
	 * @return the fichier
	 */
	public String getFichier() {
		return fichier;
	}

	/**
	 * Gets the nom fichier.
	 * 
	 * @return the nom fichier
	 */
	public String getNomFichier() {
		return nomFichier;
	}

	/**
	 * Gets the etat.
	 * 
	 * @return the etat
	 */
	public String getEtat() {
		return etat;
	}

	/**
	 * Gets the error message.
	 * 
	 * @return the error message
	 */
	public String getErrorMessage() {
		return errorMessage;
	}

	/**
	 * Gets the id newsletter.
	 * 
	 * @return the id newsletter
	 */
	public String getIdNewsletter() {
		return idNewsletter;
	}

	/**
	 * Gets the date purge.
	 * 
	 * @return the date purge
	 */
	public java.sql.Date getDatePurge() {
		return datePurge;
	}

	/**
	 * Gets the sQL base query.
	 * 
	 * @return the sQL base query
	 */
	public String getSQLBaseQuery() {
		return "SELECT DISTINCT " + "T1.ID_MAILING ,  " + "T1.EMAIL ,  " + "T1.CODE_UTILISATEUR ,  " + "T1.NOM_UTILISATEUR ,  " + "T1.REPLY_TO ,  " + "T1.OBJET ,  " + "T1.TYPE_MIME ,  " + "T1.MESSAGE ,  " + "T1.FICHIER ,  " + "T1.NOM_FICHIER ,  " + "T1.ETAT ,  " + "T1.ERROR_MESSAGE ,  " + "T1.ID_NEWSLETTER ,  " + "T1.DATE_PURGE ,  " + "T1.DATE_CREATION, " + "T1.TYPE " + "         FROM " + qualifier + "MAILING T1 ";
	}

	/**
	 * Next item.
	 * 
	 * @return true, if successful
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public boolean nextItem() throws Exception {
		boolean res = false;
		try {
			if (_rs.next()) {
				if (_rs.getObject(1) instanceof Long) {
					retrieveFromRS(_rs);
				} else {
					setIdNewsletter(_rs.getString(1));
					setObjet(_rs.getString(2));
				}
				res = true;
			} else {
				try {
					_rs.close();
				} finally {
					_rs = null;
				}
			}
		} catch (final Exception e) {
			throw new Exception("ERROR_IN_METHOD nextItem() " + e);
		}
		return res;
	}

	/**
	 * Next item user.
	 * 
	 * @return true, if successful
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public boolean nextItemUser() throws Exception {
		boolean res = false;
		try {
			if (_rs.next()) {
				setIdMailing(new Long(_rs.getString(1)));
				setEmail(_rs.getString(2));
				setNomUtilisateur(_rs.getString(3));
				setTypeMime(_rs.getString(4));
				res = true;
			}
		} catch (final Exception e) {
			throw new Exception("ERROR_IN_METHOD nextItem() " + e);
		}
		return res;
	}

	/**
	 * RÃ©cupÃ©ration d'une ligne de la base de donnÃ©es.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void retrieve() throws Exception {
		ResultSet rs = null;
		try {
			_stmt = getConnection().prepareStatement(
				"SELECT " + "             ID_MAILING," + "             EMAIL," + "             CODE_UTILISATEUR," + "             NOM_UTILISATEUR," + "             REPLY_TO," + "             OBJET," + "             TYPE_MIME," + "             MESSAGE," + "             FICHIER," + "             NOM_FICHIER," + "             ETAT," + "             ERROR_MESSAGE," + "             ID_NEWSLETTER," + "             DATE_PURGE," + "             DATE_CREATION," + "             TYPE" + "         FROM " + qualifier + "MAILING WHERE " + "             ID_MAILING = ? ");
			// put parameters into statement
			_stmt.setObject(1, getIdMailing(), Types.BIGINT);
			rs = _stmt.executeQuery();
			if (!rs.next()) {
				throw new Exception("retrieve  : METHOD_NO_RESULTS");
			}
			// get output from result set
			retrieveFromRS(rs);
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD retrieve() " + exc);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (_stmt != null) {
				_stmt.close();
				_stmt = null;
			}
		}
	}

	/**
	 * Retrieve from rs.
	 * 
	 * @param _rs
	 *            the _rs
	 * 
	 * @throws Exception
	 *             the exception
	 */
	private void retrieveFromRS(final ResultSet _rs) throws Exception {
		try {
			// get output from result set
			setIdMailing(new Long(_rs.getLong(1)));
			setEmail(_rs.getString(2));
			setCodeUtilisateur(_rs.getString(3));
			setNomUtilisateur(_rs.getString(4));
			setReplyTo(_rs.getString(5));
			setObjet(_rs.getString(6));
			setTypeMime(_rs.getString(7));
			setMessage(_rs.getString(8));
			setFichier(_rs.getString(9));
			setNomFichier(_rs.getString(10));
			setEtat(_rs.getString(11));
			setErrorMessage(_rs.getString(12));
			setIdNewsletter(_rs.getString(13));
			setDatePurge(_rs.getDate(14));
			setDateCreation(_rs.getTimestamp(15));
			setType(_rs.getString(16));
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD retrieveFromRS() " + exc);
		}
	}

	/**
	 * cette mÃ©thode optimise l'exÃ©cution de la requete (pas de count).
	 * 
	 * @param sqlSuffix
	 *            the sql suffix
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void selectNoCount(String sqlSuffix) throws Exception {
		try {
			if (sqlSuffix == null) {
				sqlSuffix = "";
			}
			_stmt = getConnection().prepareStatement(getSQLBaseQuery() + sqlSuffix);
			_rs = _stmt.executeQuery();
		} catch (final SQLException exc) {
			throw new Exception("SELECT_FAILED " + exc);
		} finally {
			_stmt = null;
		}
	}

	/**
	 * Select.
	 * 
	 * @param sqlSuffix
	 *            the sql suffix
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public int select(String sqlSuffix) throws Exception {
		int count = 0;
		try {
			if (sqlSuffix == null) {
				sqlSuffix = "";
			}
			final String query = getSQLBaseQuery() + sqlSuffix;
			_stmt = getConnection().prepareStatement(query);
			_rs = _stmt.executeQuery(query);
			_rs.last();
			count = _rs.getRow();
			_rs.beforeFirst();
		} catch (final SQLException exc) {
			throw new Exception("SELECT_FAILED " + exc);
		} finally {
			_stmt = null;
		}
		return count;
	}

	/**
	 * Select distinct par newsletter.
	 * 
	 * @param sqlSuffix
	 *            the sql suffix
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void selectDistinctParNewsletter(String sqlSuffix) throws Exception {
		try {
			if (sqlSuffix == null) {
				sqlSuffix = "";
			}
			final String query = "SELECT DISTINCT T1.ID_NEWSLETTER, T1.OBJET, T1.ID_MAILING" + " FROM " + qualifier + "MAILING T1 " + sqlSuffix;
			/* Ã©xÃ©cution requete */
			_stmt = getConnection().prepareStatement(query);
			_rs = _stmt.executeQuery();
		} catch (final SQLException exc) {
			throw new Exception("SELECT_FAILED " + exc);
		} finally {
			_stmt = null;
		}
	}

	/**
	 * Select users.
	 * 
	 * @param sqlSuffix
	 *            the sql suffix
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public int selectUsers(String sqlSuffix) throws Exception {
		int count = 0;
		try {
			if (sqlSuffix == null) {
				sqlSuffix = "";
			}
			String query = "SELECT COUNT(*)   FROM " + qualifier + "MAILING T1 " + sqlSuffix;
			/* récupération nombre de lignes */
			_stmt = getConnection().prepareStatement(query);
			_rs = _stmt.executeQuery(query);
			_rs.next();
			count = _rs.getInt(1);
			/* Ã©xÃ©cution requete */
			query = "SELECT T1.ID_MAILING, T1.EMAIL, T1.NOM_UTILISATEUR, T1.TYPE_MIME" + " from " + qualifier + "MAILING T1 " + sqlSuffix;
			_stmt = getConnection().prepareStatement(query);
			_rs = _stmt.executeQuery();
		} catch (final SQLException exc) {
			throw new Exception("SELECT_FAILED " + exc);
		} finally {
			_stmt = null;
		}
		return count;
	}

	/**
	 * Select count.
	 * 
	 * @param sqlSuffix
	 *            the sql suffix
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public int selectCount(String sqlSuffix) throws Exception {
		int count = 0;
		try {
			if (sqlSuffix == null) {
				sqlSuffix = "";
			}
			final String query = "SELECT COUNT(*)   FROM " + qualifier + "MAILING T1 " + sqlSuffix;
			/* rÃ©cupÃ©ration nombre de lignes */
			_stmt = getConnection().prepareStatement(query);
			_rs = _stmt.executeQuery(query);
			_rs.next();
			count = _rs.getInt(1);
		} catch (final SQLException exc) {
			throw new Exception("SELECT_FAILED " + exc);
		} finally {
			_stmt = null;
		}
		return count;
	}

	/**
	 * Sets the id mailing.
	 * 
	 * @param _idMailing
	 *            the new id mailing
	 */
	public void setIdMailing(final Long _idMailing) {
		idMailing = _idMailing;
	}

	/**
	 * Sets the email.
	 * 
	 * @param _email
	 *            the new email
	 */
	public void setEmail(final String _email) {
		email = _email;
	}

	/**
	 * Sets the code utilisateur.
	 * 
	 * @param _codeUtilisateur
	 *            the new code utilisateur
	 */
	public void setCodeUtilisateur(final String _codeUtilisateur) {
		codeUtilisateur = _codeUtilisateur;
	}

	/**
	 * Sets the nom utilisateur.
	 * 
	 * @param _nomUtilisateur
	 *            the new nom utilisateur
	 */
	public void setNomUtilisateur(final String _nomUtilisateur) {
		nomUtilisateur = _nomUtilisateur;
	}

	/**
	 * Sets the reply to.
	 * 
	 * @param _replyTo
	 *            the new reply to
	 */
	public void setReplyTo(final String _replyTo) {
		replyTo = _replyTo;
	}

	/**
	 * Sets the objet.
	 * 
	 * @param _objet
	 *            the new objet
	 */
	public void setObjet(final String _objet) {
		objet = _objet;
	}

	/**
	 * Sets the type mime.
	 * 
	 * @param _typeMime
	 *            the new type mime
	 */
	public void setTypeMime(final String _typeMime) {
		typeMime = _typeMime;
	}

	/**
	 * Sets the message.
	 * 
	 * @param _message
	 *            the new message
	 */
	public void setMessage(final String _message) {
		message = _message;
	}

	/**
	 * Sets the fichier.
	 * 
	 * @param _fichier
	 *            the new fichier
	 */
	public void setFichier(final String _fichier) {
		fichier = _fichier;
	}

	/**
	 * Sets the nom fichier.
	 * 
	 * @param _nomFichier
	 *            the new nom fichier
	 */
	public void setNomFichier(final String _nomFichier) {
		nomFichier = _nomFichier;
	}

	/**
	 * Sets the etat.
	 * 
	 * @param _etat
	 *            the new etat
	 */
	public void setEtat(final String _etat) {
		etat = _etat;
	}

	/**
	 * Sets the error message.
	 * 
	 * @param _errorMessage
	 *            the new error message
	 */
	public void setErrorMessage(final String _errorMessage) {
		errorMessage = _errorMessage;
	}

	/**
	 * Sets the id newsletter.
	 * 
	 * @param _idNewsletter
	 *            the new id newsletter
	 */
	public void setIdNewsletter(final String _idNewsletter) {
		idNewsletter = _idNewsletter;
	}

	/**
	 * Sets the date purge.
	 * 
	 * @param _datePurge
	 *            the new date purge
	 */
	public void setDatePurge(final java.sql.Date _datePurge) {
		datePurge = _datePurge;
	}

	/**
	 * Sets the param.
	 * 
	 * @param _ctx
	 *            the _ctx
	 * @param _qualifier
	 *            the _qualifier
	 */
	public void setParam(final OMContext _ctx, final String _qualifier) {
		ctx = _ctx;
		qualifier = "";
		if (_qualifier.equals("") == false) {
			if (_qualifier.substring(_qualifier.length() - 1).equals(".") == false) {
				qualifier = _qualifier + ".";
			} else {
				qualifier = _qualifier;
			}
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(".");
	}

	//----------------------------------------------------------------
	// Display methods
	//----------------------------------------------------------------
	/**
	 * To string.
	 * 
	 * @param aSeparator
	 *            the a separator
	 * 
	 * @return the string
	 */
	public String toString(final String aSeparator) {
		return (String.valueOf("" + aSeparator + getIdMailing() + aSeparator + getEmail() + aSeparator + getCodeUtilisateur() + aSeparator + getNomUtilisateur() + aSeparator + getReplyTo() + aSeparator + getObjet() + aSeparator + getTypeMime() + aSeparator + getMessage() + aSeparator + getFichier() + aSeparator + getNomFichier() + aSeparator + getEtat() + aSeparator + getErrorMessage() + aSeparator + getIdNewsletter() + aSeparator + getDatePurge() + aSeparator + getDateCreation() + aSeparator + getType()));
	}

	/**
	 * Mise Ã  jour d'une ligne de la base de donnÃ©es.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void update() throws Exception {
		try {
			_stmt = getConnection().prepareStatement(
				"UPDATE " + qualifier + "MAILING SET " + "ID_MAILING = ?, " + "EMAIL = ?, " + "CODE_UTILISATEUR = ?, " + "NOM_UTILISATEUR = ?, " + "REPLY_TO = ?, " + "OBJET = ?, " + "TYPE_MIME = ?, " + "MESSAGE = ?, " + "FICHIER = ?, " + "NOM_FICHIER = ?, " + "ETAT = ?, " + "ERROR_MESSAGE = ?, " + "ID_NEWSLETTER = ?, " + "DATE_PURGE = ?, " + "DATE_CREATION = ?, " + "TYPE = ? " + "         WHERE " + "             ID_MAILING = ? ");
			// put parameters into statement
			_stmt.setObject(1, getIdMailing(), Types.BIGINT);
			_stmt.setObject(2, getEmail(), Types.LONGVARCHAR);
			_stmt.setObject(3, getCodeUtilisateur(), Types.VARCHAR);
			_stmt.setObject(4, getNomUtilisateur(), Types.VARCHAR);
			_stmt.setObject(5, getReplyTo(), Types.VARCHAR);
			_stmt.setObject(6, getObjet(), Types.VARCHAR);
			_stmt.setObject(7, getTypeMime(), Types.VARCHAR);
			_stmt.setObject(8, getMessage(), Types.LONGVARCHAR);
			_stmt.setObject(9, getFichier(), Types.VARCHAR);
			_stmt.setObject(10, getNomFichier(), Types.VARCHAR);
			_stmt.setObject(11, getEtat(), Types.VARCHAR);
			_stmt.setObject(12, getErrorMessage(), Types.VARCHAR);
			_stmt.setObject(13, getIdNewsletter(), Types.VARCHAR);
			_stmt.setObject(14, getDatePurge(), Types.DATE);
			_stmt.setObject(15, getDateCreation(), Types.TIMESTAMP);
			_stmt.setObject(16, getType(), Types.VARCHAR);
			_stmt.setObject(17, getIdMailing(), Types.BIGINT);
			_stmt.executeUpdate();
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD update() " + exc);
		} finally {
			if (_stmt != null) {
				_stmt.close();
				_stmt = null;
			}
		}
	}

	/**
	 * Mise Ã  jour d'une ligne de la base de donnÃ©es.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void updatePostEnvoi() throws Exception {
		try {
			_stmt = getConnection().prepareStatement("UPDATE " + qualifier + "MAILING SET ETAT = ? WHERE ID_MAILING = ? ");
			// put parameters into statement
			_stmt.setObject(1, getEtat(), Types.VARCHAR);
			_stmt.setObject(2, getIdMailing(), Types.BIGINT);
			_stmt.executeUpdate();
			_stmt.close();
		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD update() " + exc);
		} finally {
			_stmt = null;
		}
	}

	/**
	 * Mise à jour des emails d'une ligne de la base de données.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void updateDestinataire() throws Exception {

		try (PreparedStatement stmt = getConnection().prepareStatement("UPDATE " + qualifier + "MAILING SET EMAIL = ? WHERE ID_MAILING = ? ");) {
			stmt.setObject(1, getEmail(), Types.VARCHAR);
			stmt.setObject(2, getIdMailing(), Types.BIGINT);
			stmt.executeUpdate();

		} catch (final SQLException exc) {
			throw new Exception("ERROR_IN_METHOD updateDestinataire() " + exc);
		}
	}

	/**
	 * Sets the ctx.
	 * 
	 * @param _ctx
	 *            the new ctx
	 */
	public void setCtx(final OMContext _ctx) {
		setParam(_ctx, "");
	}

	/**
	 * @return the dateCreation
	 */
	public Timestamp getDateCreation() {
		return dateCreation;
	}

	/**
	 * @param dateCreation
	 *            the dateCreation to set
	 */
	public void setDateCreation(final Timestamp dateCreation) {
		this.dateCreation = dateCreation;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(final String type) {
		this.type = type;
	}
}
