/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.util;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.ReferenceBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

// TODO: Auto-generated Javadoc
/**
 * processus d'affichage des références croisées.
 */
public class AffichageReferences {

	private static final Logger LOG = LoggerFactory.getLogger(AffichageReferences.class);

	public static List<ReferenceBean> getListeReferences(OMContext ctx, InfoBean infoBean) throws Exception {
		List<ReferenceBean> referencesDispo = new ArrayList<ReferenceBean>();
		String codeObjet = infoBean.getString("CODE_OBJET");
		String codeFiche = infoBean.getString("CODE");
		String langue = infoBean.getString("LANGUE");
		if (StringUtils.isNotBlank(codeObjet)) {
			Metatag meta = new Metatag();
			meta.init();
			meta.setCtx(ctx);
			meta.selectParReferences(codeObjet, codeFiche, langue, Long.valueOf(0));
			while (meta.nextItem()) {
				FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
				ficheUniv.setCtx(ctx);
				ficheUniv.init();
				ficheUniv.setIdFiche(meta.getMetaIdFiche());
				try {
					ficheUniv.retrieve();
					if (EtatFiche.isEtatPerene(ficheUniv.getEtatObjet())) {
						ReferenceBean reference = new ReferenceBean();
						reference.setTitre(ficheUniv.getLibelleAffichable());
						reference.setLangue(ficheUniv.getLangue());
						reference.setType(ReferentielObjets.getLibelleObjet(meta.getMetaCodeObjet()));
						reference.setEtat(EtatFiche.getEtatParCode(ficheUniv.getEtatObjet()));
						referencesDispo.add(reference);
					}
				} catch (Exception e) {
					LOG.info("impossible de récuperer la fiche depuis les metas", e);
				}
			}
			Rubrique rub = new Rubrique();
			rub.init();
			rub.setCtx(ctx);
			ClauseWhere whereCodeObjet = new ClauseWhere();
			String codePageTete = codeFiche + ",LANGUE=" + langue + ",TYPE=" + ReferentielObjets.getNomObjet(codeObjet);
			whereCodeObjet.setPremiereCondition(ConditionHelper.egalVarchar("CODE_PAGE_TETE", codePageTete));
			String chaineIdFiche = "[id-fiche]" + ReferentielObjets.getNomObjet(codeObjet) + "[/id-fiche]";
			whereCodeObjet.or(ConditionHelper.like("ENCADRE", chaineIdFiche, "%", "%"));
			whereCodeObjet.or(ConditionHelper.like("ACCROCHE", chaineIdFiche, "%", "%"));
			rub.select(whereCodeObjet.formaterSQL());
			while (rub.nextItem()) {
				String titre = rub.getIntitule();
				InfosRubriques rubAriane = Rubrique.renvoyerItemRubrique(rub.getCodeRubriqueMere());
				while (rubAriane != null && rubAriane.getOnglet() != null && rubAriane.getOnglet().length() > 0) {
					titre = rubAriane.getOnglet() + " &gt; " + titre;
					rubAriane = rubAriane.getRubriqueMere();
				}
				ReferenceBean reference = new ReferenceBean();
				reference.setTitre(titre);
				reference.setType("Rubrique");
				reference.setEtat(EtatFiche.EN_LIGNE);
				reference.setLangue(rub.getLangue());
				referencesDispo.add(reference);
			}
		}
		return referencesDispo;
	}
}
