/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteUniv;
import com.univ.utils.FicheUnivHelper;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.SessionUtil;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseOrderBy.SensDeTri;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;

public class ReferentielObjetsUtil {

	/**
	 * Methode renvoyant une Hashtable contenant les couples(TypeObjet,Thematique) des objets metiers
	 *
	 * @param ctx
	 * @return Hashtable<type objet, nom objet>
	 * @throws Exception
	 * @deprecated méthode plus utilisée
	 */
	@Deprecated
	public static Hashtable<String, String> getListeTypedeFiche(final ContexteUniv ctx) throws Exception {
		final Hashtable<String, String> mapsListeFiche = new Hashtable<>();
		for (final Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
			if (objet.isRecherchable()) {
				mapsListeFiche.put(objet.getNomObjet(), objet.getLibelleObjet());
			}
		}
		return mapsListeFiche;
	}

	/**
	 * Calcule les types de fiches dont on peut créer des fiches via le backoffice
	 *
	 * @return la liste des objets créable par l'utilisateur
	 */
	public static List<Objetpartage> getListeFichesCreableBO(final ContexteUniv ctx) {
		final AutorisationBean autorisations = ctx.getAutorisation();
		final List<Objetpartage> objetCreableBO = new ArrayList<>();
		for (final Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
			final FicheUniv fiche = FicheUnivHelper.instancierFiche(objet.getCodeObjet());
			if (autorisations.getAutorisation(objet.getCodeObjet(), AutorisationBean.INDICE_CREATION)) {
				if (fiche != null && FicheAnnotationHelper.isLienInterne(fiche) && FicheAnnotationHelper.isAccessibleBo(fiche)) {
					objetCreableBO.add(objet);
				}
			}
		}
		return objetCreableBO;
	}

	public static List<FicheUniv> getListeMesFichesRecentes(final ContexteUniv ctx, final int combien) throws Exception {
		final String codeRedacteur = (String) SessionUtil.getInfosSession(ctx.getRequeteHTTP()).get(SessionUtilisateur.CODE);
		final AutorisationBean autorisations = ctx.getAutorisation();
		final List<FicheUniv> liste = new ArrayList<>();
		final Metatag metatag = new Metatag();
		metatag.setCtx(ctx);
		metatag.init();
		final ClauseWhere whereCodeRedacteur = new ClauseWhere(ConditionHelper.egalVarchar("META_CODE_REDACTEUR", codeRedacteur));
		final ClauseOrderBy orderBy = new ClauseOrderBy("META_DATE_MODIFICATION", SensDeTri.DESC);
		final ClauseLimit limit = new ClauseLimit(combien);
		final RequeteSQL req = new RequeteSQL();
		final String codeRubrique = "";
		final ConditionList conditionSurObjets = new ConditionList();
		for (final String nomObjet : ReferentielObjets.getListeNomsObjet()) {
			final FicheUniv fiche = ReferentielObjets.instancierFiche(nomObjet);
			if (fiche != null && FicheAnnotationHelper.isAccessibleBo(fiche)) {
				fiche.setCodeRubrique(codeRubrique);
				conditionSurObjets.or(RequeteSQLHelper.traiterConditionDsiMeta(autorisations, fiche, "", codeRubrique, null));
			}
		}
		whereCodeRedacteur.and(conditionSurObjets);
		whereCodeRedacteur.and(ConditionHelper.getConditionRubPubSuivantAction(ctx, "", "T1.META_CODE_RUBRIQUE", codeRubrique));
		req.where(whereCodeRedacteur).orderBy(orderBy).limit(limit);
		metatag.select(req.formaterRequete());
		while (metatag.nextItem()) {
			final FicheUniv f = ReferentielObjets.instancierFiche(metatag.getMetaCodeObjet());
			if (f != null) {
				f.setCtx(ctx);
				f.init();
				f.selectCodeLangueEtat(metatag.getMetaCode(), metatag.getMetaLangue(), metatag.getMetaEtatObjet());
				if (f.nextItem()) {
					liste.add(f);
				}
			}
		}
		return liste;
	}

	public static int compterMesFiches(final ContexteUniv ctx) throws Exception {
		final String codeRedacteur = (String) SessionUtil.getInfosSession(ctx.getRequeteHTTP()).get(SessionUtilisateur.CODE);
		final AutorisationBean autorisations = ctx.getAutorisation();
		final Metatag metatag = new Metatag();
		metatag.setCtx(ctx);
		metatag.init();
		final ClauseWhere whereCodeRedacteur = new ClauseWhere(ConditionHelper.egalVarchar("META_CODE_REDACTEUR", codeRedacteur));
		final ClauseOrderBy orderBy = new ClauseOrderBy("META_DATE_MODIFICATION", SensDeTri.DESC);
		final RequeteSQL req = new RequeteSQL();
		final String codeRubrique = "";
		final ConditionList conditionSurObjets = new ConditionList();
		for (final Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
			final FicheUniv fiche = ReferentielObjets.instancierFiche(objet.getNomObjet());
			if (! objet.isStrictlyCollaboratif() && fiche != null) {
				fiche.setCodeRubrique(codeRubrique);
				conditionSurObjets.or(RequeteSQLHelper.traiterConditionDsiMeta(autorisations, fiche, "", codeRubrique, null));
			}
		}
		whereCodeRedacteur.and(conditionSurObjets);
		whereCodeRedacteur.and(ConditionHelper.getConditionRubPubSuivantAction(ctx, "", "T1.META_CODE_RUBRIQUE", codeRubrique));
		req.where(whereCodeRedacteur).orderBy(orderBy);
		return metatag.selectCount(req.formaterRequete());
	}

	public static List<FicheUniv> getListeDernieresModifications(final ContexteUniv ctx, final int combien) throws Exception {
		final AutorisationBean autorisations = ctx.getAutorisation();
		final List<FicheUniv> liste = new ArrayList<>();
		final Metatag metatag = new Metatag();
		metatag.setCtx(ctx);
		metatag.init();
		final ClauseOrderBy orderBy = new ClauseOrderBy("META_DATE_MODIFICATION", SensDeTri.DESC);
		final ClauseLimit limit = new ClauseLimit(combien);
		final RequeteSQL req = new RequeteSQL();
		req.orderBy(orderBy).limit(limit);
		metatag.select(req.formaterRequete());
		while (metatag.nextItem()) {
			final FicheUniv f = ReferentielObjets.instancierFiche(metatag.getMetaCodeObjet());
			if (f != null) {
				f.setCtx(ctx);
				f.init();
				f.selectCodeLangueEtat(metatag.getMetaCode(), metatag.getMetaLangue(), metatag.getMetaEtatObjet());
				if (f.nextItem()) {
					final Metatag meta = FicheUnivMgr.lireMeta(f);
					String codeApprobation = "";
					if (!"".equals(meta.getMetaNiveauApprobation())) {
						codeApprobation = meta.getMetaNiveauApprobation();
					}
					if (autorisations.getAutorisationParFiche(f, AutorisationBean.INDICE_APPROBATION, codeApprobation)) {
						liste.add(f);
					}
				}
			}
		}
		return liste;
	}

	/**
	 * @deprecated Hmm, en fait cette méthode retourne le nombre de tuple qu'il y a dans la table meta. C'est bien, mais pas top.
	 */
	@Deprecated
	public static int compterDernieresModifications(final ContexteUniv ctx) throws Exception {
		final Metatag metatag = new Metatag();
		metatag.setCtx(ctx);
		metatag.init();
		return metatag.selectCount(StringUtils.EMPTY);
	}
}
