/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.util;

import org.apache.commons.lang3.StringUtils;

import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;


public class RessourceUtil {

	/** The Constant PATH_SERVLET_LECTURE_FICHIER. */
	public static final String PATH_SERVLET_LECTURE_FICHIER = "/servlet/com.univ.collaboratif.utils.LectureFichiergw";

	/** The Constant FICHIERGW_PATH_PROPERTIES_KEY. */
	private static final String FICHIERGW_PATH_PROPERTIES_KEY = "fichiergw.path";

	private static final String DEFAULT_RESSOURCE_PATH = "/WEB-INF/fichiergw";

	public static String getAbsolutePath() {
		return StringUtils.defaultIfEmpty(PropertyHelper.getCoreProperty(FICHIERGW_PATH_PROPERTIES_KEY), WebAppUtil.getAbsolutePath()+DEFAULT_RESSOURCE_PATH);
	}

	public static String getDefaultRelativePath() {
		return DEFAULT_RESSOURCE_PATH;
	}
}
