/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.pluto.om.ControllerObjectAccess;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.om.common.LanguageSet;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.ContentType;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.om.servlet.ServletDefinitionCtrl;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.om.window.PortletWindowCtrl;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.om.window.PortletWindowListCtrl;
import org.apache.pluto.portalImpl.servlet.ServletResponseImpl;
import org.apache.pluto.services.information.PortalContextProvider;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.lang.CharEncoding;
import com.univ.portail.core.FactoryAccess;
import com.univ.portail.core.PortalControlParameter;
import com.univ.portail.core.PortalEnvironment;
import com.univ.portail.core.PortalURL;
import com.univ.portail.core.PortletContainerFactory;
import com.univ.portail.core.SessionStatefullParameter;
import com.univ.portail.core.impl.DynamicTitleServiceImpl;
import com.univ.portail.om.window.impl.PortletWindowImpl;
import com.univ.portail.service.registry.PortletEntityRegistry;
import com.univ.portail.servlet.ServletObjectAccess;
import com.univ.portail.servlet.ServletRequestImpl;
import com.univ.services.CacheServiceViewManager;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ServicesUtil;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * Responsible for rendering a single Portlet.
 * <p>
 * 
 * <p>
 * Requires two JSP files to exist, PortletFragmentHeader.jsp and PortletFragmentFooter.jsp. These pages define the header and footer of the portlet.
 * </p>
 * 
 * <p>
 * A PortletFragment.PortletInfo object is added to the request attributes and makes information about the Portlet available to the header and footer JSP pages.
 * </p>
 * 
 * @author Stephan Hesmer
 * @author Nick Lothian
 */
public class KportalPortletFragment {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(KportalPortletFragment.class);

	/** The Constant OCCURENCE_SUFFIXE. */
	public static final String OCCURENCE_SUFFIXE = "_occ";

	/** The portlet window. */
	private PortletWindow portletWindow = null;

	/** The name. */
	public String name = null;

	/** The Constant PORTLET_ERROR_MSG. */
	public static final String PORTLET_ERROR_MSG = "Error occurred in portlet!";

	/**
	 * Instantiates a new kportal portlet fragment.
	 * 
	 * @param id
	 *            the id
	 * @throws PortletException
	 *             the portlet exception
	 */
	public KportalPortletFragment(final String id) throws PortletException {
		String portletEntityId = null;
		if (id.indexOf(OCCURENCE_SUFFIXE) != -1) {
			portletEntityId = id.substring(0, id.indexOf(OCCURENCE_SUFFIXE));
		} else {
			portletEntityId = id;
		}
		final PortletEntity portletEntity = PortletEntityRegistry.getPortletEntity(portletEntityId);
		if (portletEntity == null) {
			LOG.error("La portlet demandée: '" + id + "' n'existe pas.");
			throw new PortletException("La portlet demandée: '" + id + "' n'existe pas.");
		}
		portletWindow = new PortletWindowImpl(id);
		((PortletWindowCtrl) portletWindow).setPortletEntity(portletEntity);
		final PortletWindowList windowList = portletEntity.getPortletWindowList();
		((PortletWindowListCtrl) windowList).add(portletWindow);
	}

	/**
	 * Service.
	 * 
	 * @param ctx
	 *            the ctx
	 * @param encodage
	 *            the encodage
	 * 
	 * @return the string
	 * 
	 * @throws ServletException
	 *             the servlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	public String service(final ContexteUniv ctx, final String encodage) throws ServletException, IOException {
		String idService = portletWindow.getId().toString();
		if (idService.indexOf("_occ") != -1) {
			idService = idService.substring(0, idService.indexOf("_occ"));
		}
		LOG.debug("Fragment.service(" + idService + " ) début");
		/*Vérification des droits...
		if (ctx.getAutorisation() == null) {
		    return "Vous n'êtes pas loggués, le service '" + idService + "' ne vous est pas accessible.";
		}*/
		if (!ctx.getListeServicesAutorises().contains(idService)) {
			return "Vous n'êtes pas autorisés à exécuter le service '" + idService + "'.";
		}
		final HttpServletRequest request = ctx.getRequeteHTTP();
		final HttpServletResponse response = ctx.getReponseHTTP();
		final HttpServletRequest wrappedRequest = ServletObjectAccess.getServletRequest(request, portletWindow);
		if (wrappedRequest instanceof ServletRequestImpl) {
			((ServletRequestImpl) wrappedRequest).setLocale(ctx.getLocale());
		}
		wrappedRequest.setAttribute("kportal.ctx", ctx);
		final StringWriter storedWriter = new StringWriter();
		final PrintWriter writer2 = new PrintWriter(storedWriter);
		// create a wrapped response which the Portlet will be rendered to
		final ServletResponseImpl wrappedResponse = (ServletResponseImpl) ServletObjectAccess.getStoredServletResponse(response, writer2);
		// load the Portlet
		// If there is an error loading, then we will save the error message and attempt
		// to render it inside the Portlet, so the Portal has a chance of still looking okay
		String errorMsg = null;
		/*
		 * on tente tout d'abord de charger la portlet. si elle répond, c'est qu'elle est disponible,
		 * on peut donc appeler la méthode désirée; Si la portlet ne répond pas, on va tenter d'ajouter
		 * un message d'erreur dans le contenu de la portlet afin que le rendu visuel du portail soit ok.
		 */
		//		try {
		//			PortletContainerFactory.getPortletContainer().portletLoad(portletWindow, wrappedRequest, wrappedResponse);
		//		} catch (PortletContainerException e) {
		//			Log.error("Error in Portlet", e);
		//			errorMsg = getErrorMsg();
		//		} catch (Throwable t) {
		//			// If we catch any throwable, we want to try to continue
		//			// so that the rest of the portal renders correctly
		//			Log.error("Error in Portlet", t);
		//			if (t instanceof VirtualMachineError) {
		//				// if the Throwable is a VirtualMachineError then
		//				// it is very unlikely (!) that the portal is going
		//				// to render correctly.
		//				throw (Error) t;
		//			} else {
		//				errorMsg = getErrorMsg();
		//			}
		//		}
		final PortalEnvironment reqPortalEnv = PortalEnvironment.getPortalEnvironment(request);
		/* création portalUrl à partir de la requête principale */
		final PortalURL newPortalURL = new PortalURL(reqPortalEnv);
		// Ajout paramétres statefull stockés en session
		final Map statefullsParameters = SessionStatefullParameter.getFromSession(request, portletWindow.getId().toString());
		if (statefullsParameters != null) {
			newPortalURL.setSessionStatefullParameter(statefullsParameters);
		}
		final PortalControlParameter newPortalControlParameter = new PortalControlParameter(newPortalURL);
		//      String unitaire[] = newPortalControlParameter.getKportalParamValues(portletWindow,"UNITAIRE");
		newPortalControlParameter.getStateFullControlParameter().put("pid", portletWindow.getId().toString());
		/*
		 // Debug des statefulls
		Iterator iKeys = newPortalControlParameter.getStateFullControlParameter().keySet().iterator();
		while( iKeys.hasNext()){
		    String nom = (String) iKeys.next();
		    Log.debug("statefull "+portletWindow.getId()+ " ["+ nom + "] = " +newPortalControlParameter.getStateFullControlParameter().get(nom));
		}
		 */
		boolean modifStatefull = false;
		if (ctx.getMetaCourant() != null) {
			newPortalControlParameter.setKportalParam(portletWindow, "ID_META", new String[] { ctx.getMetaCourant().getIdMetatag().toString() });
			modifStatefull = true;
		}
		if (ctx.getCodeRubriqueHistorique() != null && ctx.getCodeRubriqueHistorique().length() > 0) {
			newPortalControlParameter.setKportalParam(portletWindow, "RH", new String[] { ctx.getCodeRubriqueHistorique() });
			modifStatefull = true;
		}
		if ("unitaire".equals(newPortalURL.getUrlParameter("AFFICHAGE"))) {
			newPortalControlParameter.setKportalParam(portletWindow, "UNITAIRE", new String[] { "1" });
			modifStatefull = true;
		}
		if (modifStatefull) {
			SessionStatefullParameter.saveIntoSession(request, portletWindow.getId().toString(), newPortalControlParameter);
		}
		/* Création d'un environnement associé à la requête wrappée */
		final PortalEnvironment wrapReqPortalEnv = new PortalEnvironment(wrappedRequest, wrappedResponse);
		newPortalURL.setEnv(wrapReqPortalEnv);
		wrapReqPortalEnv.changeRequestedPortalURL(newPortalURL, newPortalControlParameter);
		wrappedRequest.setAttribute(PortalEnvironment.REQUEST_PORTALENV, wrapReqPortalEnv);
		((ServletRequestImpl) wrappedRequest).setControl(newPortalControlParameter);
		final PortletDefinition portletDefinition = portletWindow.getPortletEntity().getPortletDefinition();
		final LanguageSet languageSet = portletDefinition.getLanguageSet();
		Locale lo = LangueUtil.getDefaultLocale();
		if (request.getLocale() != null) {
			lo = request.getLocale();
		}
		final Language lang = languageSet.get(lo);
		String title = lang != null ? lang.getTitle() : "no title available";
		String contenuPortlet = null;
		final ServletDefinition servletDefinition = portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition();
		if (servletDefinition != null && !servletDefinition.isUnavailable()) {
			try {
				// render the Portlet to the wrapped response, to be output later.
				if ((newPortalControlParameter.getMode(portletWindow).equals(PortletMode.VIEW)) && (newPortalControlParameter.getState(portletWindow).equals(WindowState.NORMAL))) {
					final String codeService = portletWindow.getPortletEntity().getId().toString();
					final com.univ.objetspartages.om.ServiceBean service = ServicesUtil.getService(codeService);
					contenuPortlet = CacheServiceViewManager.getContenuPortlet(ctx, service, portletWindow, storedWriter, wrappedRequest, wrappedResponse);
				} else {
					PortletContainerFactory.getPortletContainer().portletLoad(portletWindow, wrappedRequest, wrappedResponse);
					PortletContainerFactory.getPortletContainer().renderPortlet(portletWindow, wrappedRequest, wrappedResponse);
					contenuPortlet = storedWriter.toString();
				}
			} catch (final UnavailableException e) {
				LOG.error("Portlet is Unavailable", e);
				writer2.println("the portlet is currently unavailable!");
				final ServletDefinitionCtrl servletDefinitionCtrl = (ServletDefinitionCtrl) ControllerObjectAccess.get(portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition());
				if (e.isPermanent()) {
					servletDefinitionCtrl.setAvailable(Long.MAX_VALUE);
				} else {
					int unavailableSeconds = e.getUnavailableSeconds();
					if (unavailableSeconds <= 0) {
						unavailableSeconds = 60; // arbitrary default
					}
					servletDefinitionCtrl.setAvailable(System.currentTimeMillis() + unavailableSeconds * 1000);
				}
			} catch (final Exception e) {
				LOG.error("Error in Portlet", e);
				errorMsg = getErrorMsg();
			}
			final String dyn_title = ((DynamicTitleServiceImpl) FactoryAccess.getDynamicTitleContainerService()).getDynamicTitle(portletWindow, wrappedRequest);
			if (dyn_title != null) {
				title = dyn_title;
			}
		}
		// create a PortletInfo object. This is used to communicate with header and footer JSP pages of this portlet
		final PortletInfo portletInfo = new PortletInfo();
		// set the title, so the header JSP page can use it when rendering
		portletInfo.setTitle(title);
		portletInfo.setNomAncre(portletWindow.getId().toString());
		final ContentType supported = portletDefinition.getContentTypeSet().get(wrappedResponse.getContentType());
		final PortalContextProvider portalContextProvider = FactoryAccess.getStaticProvider().getPortalContextProvider();
		// get the list of modes this Portlet supports
		if (supported != null && portalContextProvider != null) {
			// if portlet supports portlet modes
			final Iterator<PortletMode> modes = supported.getPortletModes();
			final PortletMode currentMode = newPortalControlParameter.getMode(portletWindow);
			while (modes.hasNext()) {
				final PortletMode mode = modes.next();
				// check whether portal also supports portlet mode
				boolean portalSupport = false;
				final Iterator<PortletMode> portalSupportedModes = portalContextProvider.getSupportedPortletModes().iterator();
				while (portalSupportedModes.hasNext()) {
					final PortletMode portalSupportedMode = portalSupportedModes.next();
					if (mode.equals(portalSupportedMode)) {
						portalSupport = true;
						break;
					}
				}
				// create links for portlet modes in portlet header
				if (portalSupport) {
					//PortalURL modeURL = newPortalURL;
					//PortalControlParameter control = new PortalControlParameter(modeURL);
					//PortletMode currentMode = control.getMode(portletWindow);
					//control.setMode(portletWindow, mode);
					newPortalControlParameter.setMode(portletWindow, mode);
					//portletInfo.addPortletMode(mode, modeURL.toString(control, new Boolean(request.isSecure())), mode.equals(currentMode));
					portletInfo.addPortletMode(mode, newPortalURL.toString(newPortalControlParameter, new Boolean(request.isSecure())), mode.equals(currentMode));
				}
			}
			newPortalControlParameter.setMode(portletWindow, currentMode);
			// get the list of window states this Portlet supports
			final WindowState currentState = newPortalControlParameter.getState(portletWindow);
			final Iterator<WindowState> states = portalContextProvider.getSupportedWindowStates().iterator();
			boolean affichageUnitaire = false;
			final String unitaire[] = newPortalControlParameter.getKportalParamValues(portletWindow, "UNITAIRE");
			if (unitaire != null) {
				if ("1".equals(unitaire[0])) {
					affichageUnitaire = true;
				}
			}
			while ((!affichageUnitaire) && states.hasNext()) {
				final WindowState state = states.next();
				//PortalURL stateURL = newPortalURL;
				//PortalControlParameter control = new PortalControlParameter(stateURL);
				//control.setState(portletWindow, state);
				//portletInfo.addPortletWindowState(state.toString().substring(0, 3), stateURL.toString(control, new Boolean(request.isSecure())), state.equals(currentState));
				newPortalControlParameter.setState(portletWindow, state);
				portletInfo.addPortletWindowState(state.toString().substring(0, 3), newPortalURL.toString(newPortalControlParameter, new Boolean(request.isSecure())),
					state.equals(currentState));
			}
			newPortalControlParameter.setState(portletWindow, currentState);
		}
		/* Gestion de l'encodage */
		if (contenuPortlet != null) {
			if (encodage != null && encodage.length() > 0) {
				if (encodage.equals("I")) {
					contenuPortlet = new String(contenuPortlet.getBytes(), CharEncoding.DEFAULT);
				} else if (encodage.equals("U")) {
					contenuPortlet = new String(contenuPortlet.getBytes(), CharEncoding.DEFAULT);
				}
			}
		}
		// output the header JSP page
		final HttpServletRequest wrappedRequestKportal = ServletObjectAccess.getServletRequest(request, portletWindow);
		if (wrappedRequestKportal instanceof ServletRequestImpl) {
			((ServletRequestImpl) wrappedRequestKportal).setLocale(ctx.getLocale());
		}
		final StringWriter storedWriterKportal = new StringWriter();
		final PrintWriter printWriterKportal = new PrintWriter(storedWriterKportal);
		final ServletResponseImpl wrappedResponseKportal = (ServletResponseImpl) ServletObjectAccess.getStoredServletResponse(response, printWriterKportal);
		//request.setAttribute("portletInfo", portletInfo);
		wrappedRequestKportal.setAttribute("portletInfo", portletInfo);
		try {
			//on inclue l'entete de la portlet
			final RequestDispatcher rd = ctx.getServletContext().getRequestDispatcher("/adminsite/portal/PortletFragmentHeader.jsp");
			//rd.include(request, wrappedResponseKportal);
			rd.include(wrappedRequestKportal, wrappedResponseKportal);
			// on inclue le contenu de la portlet en vérifiant que l'on a pas eu d'erreur précédemment
			if (errorMsg == null) {
				// no error message, so output the Portlet
				if (portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition().isUnavailable()) {
					// the portlet is unavailable
					printWriterKportal.println("the portlet is currently unavailable!");
				} else {
					//on ne fait rien
					//commenté Kportal. on n'écrit pas dans la réponse directement, mais on renvoit le flux obtenu de la portlet pour l'afficher plus tard
					//printWriterKportal.println(storedWriter.toString());
					printWriterKportal.println(contenuPortlet);
				}
			} else {
				// output the errror message
				printWriterKportal.println(errorMsg);
			}
			// output the footer JSP page
			final RequestDispatcher rdFooter = ctx.getServletContext().getRequestDispatcher("/adminsite/portal/PortletFragmentFooter.jsp");
			//rdFooter.include(request, wrappedResponseKportal);
			rdFooter.include(wrappedRequestKportal, wrappedResponseKportal);
			request.removeAttribute("portletInfo");
		} catch (final ServletException e) {
			LOG.error("Exception en tentant de construire le rendu de la portlet '" + idService, e);
			throw e;
		} catch (final IOException e) {
			LOG.error("Exception en tentant de construire le rendu de la portlet '" + idService, e);
			throw e;
		}
		// En page libre, il faut garder les '\n'
		// pour qu'ils ne soient pas transformés en <BR>, ce qui est le
		// comportement par défaut de formaterEnHTML
		// C'est par exemple le cas pour les javascript commentés
		// <script>
		// <!--
		// function xxx()
		//
		// NE DOIT PAS devenir
		// <script>
		// <!-- function xxx()
		//WindowState currentState = newPortalControlParameter.getState(portletWindow);
		//		if( WindowState.MAXIMIZED.equals(currentState))
		return storedWriterKportal.toString();
		//		else
		//		    return "[noformat]"+storedWriterKportal.toString()+"[/noformat]";
	}

	/**
	 * Creates the url.
	 * 
	 * @param url
	 *            the url
	 */
	public void createURL(final PortalURL url) {
		LOG.debug("create url");
		//		getParent().createURL(url);
		//		url.addLocalNavigation(getId());
	}

	/**
	 * Checks if is part of url.
	 * 
	 * @param url
	 *            the url
	 * 
	 * @return true, if is part of url
	 */
	public boolean isPartOfURL(final PortalURL url) {
		return true;
	}

	/**
	 * Gets the portlet window.
	 * 
	 * @return the portlet window
	 */
	public PortletWindow getPortletWindow() {
		return portletWindow;
	}

	/**
	 * The Class PortletInfo.
	 */
	public static class PortletInfo {

		/** The nom ancre. */
		private String nomAncre = null;

		/** The title. */
		private String title;

		/** The available portlet modes. */
		private final List<PortletModeInfo> availablePortletModes = new ArrayList<PortletModeInfo>();

		/** The available portlet window states. */
		private final List<PortletWindowStateInfo> availablePortletWindowStates = new ArrayList<PortletWindowStateInfo>();

		/**
		 * Gets the title.
		 * 
		 * @return portlet title.
		 */
		public String getTitle() {
			return title;
		}

		/**
		 * Sets the title.
		 * 
		 * @param string
		 *            representing the new title.
		 */
		public void setTitle(final String string) {
			title = string;
		}

		/**
		 * Gets the available portlet modes.
		 * 
		 * @return available modes
		 */
		public List<PortletModeInfo> getAvailablePortletModes() {
			return availablePortletModes;
		}

		/**
		 * Adds the portlet mode.
		 * 
		 * @param mode
		 *            the mode
		 * @param activationURL
		 *            the activation url
		 * @param isCurrent
		 *            the is current
		 */
		public void addPortletMode(final PortletMode mode, final String activationURL, final boolean isCurrent) {
			final PortletModeInfo pmi = new PortletModeInfo(mode.toString(), activationURL, isCurrent);
			availablePortletModes.add(pmi);
		}

		/**
		 * Gets the available portlet window states.
		 * 
		 * @return list of all available portlet states.
		 */
		public List<PortletWindowStateInfo> getAvailablePortletWindowStates() {
			return availablePortletWindowStates;
		}

		/**
		 * Adds the portlet window state.
		 * 
		 * @param stateLabel
		 *            the state label
		 * @param activationURL
		 *            the activation url
		 * @param isCurrent
		 *            the is current
		 */
		public void addPortletWindowState(final String stateLabel, final String activationURL, final boolean isCurrent) {
			final PortletWindowStateInfo pwsi = new PortletWindowStateInfo(stateLabel, activationURL, isCurrent);
			availablePortletWindowStates.add(pwsi);
		}

		/**
		 * Gets the nom ancre.
		 * 
		 * @return the nom ancre
		 */
		public String getNomAncre() {
			return nomAncre;
		}

		/**
		 * Sets the nom ancre.
		 * 
		 * @param nomAncre
		 *            the new nom ancre
		 */
		public void setNomAncre(final String nomAncre) {
			this.nomAncre = nomAncre;
		}
	}

	/**
	 * The Class PortletWindowStateInfo.
	 */
	public static class PortletWindowStateInfo implements Comparable<PortletWindowStateInfo> {

		/** The label. */
		private String label;

		/** The url. */
		private String url;

		/** The is current. */
		private boolean isCurrent;

		/**
		 * Compare to.
		 * 
		 * @param compare
		 *            the compare
		 * 
		 * @return the int
		 * 
		 * @see java.lang.Comparable#compareTo(java.lang.Object)
		 */
		@Override
		public int compareTo(final PortletWindowStateInfo compare) {
			if (!(compare instanceof PortletWindowStateInfo)) {
				throw new ClassCastException(compare + " is not a " + PortletWindowStateInfo.class.getName());
			} else {
				final PortletWindowStateInfo other = compare;
				return this.getLabel().compareTo(other.getLabel());
			}
		}

		/**
		 * Checks if is current min.
		 * 
		 * @return true, if is current min
		 */
		public boolean isCurrentMin() {
			return "min".equals(label);
		}

		/**
		 * The Constructor.
		 * 
		 * @param stateLabel
		 *            the state label
		 * @param activationURL
		 *            the activation url
		 * @param isCurrent
		 *            the is current
		 */
		public PortletWindowStateInfo(final String stateLabel, final String activationURL, final boolean isCurrent) {
			this.label = stateLabel;
			this.url = activationURL;
			this.isCurrent = isCurrent;
		}

		/**
		 * Gets the label.
		 * 
		 * @return the label.
		 */
		public String getLabel() {
			return label;
		}

		/**
		 * Sets the label.
		 * 
		 * @param string
		 *            the string
		 */
		public void setLabel(final String string) {
			label = string;
		}

		/**
		 * Checks if is current.
		 * 
		 * @return current indicator.
		 */
		public boolean isCurrent() {
			return isCurrent;
		}

		/**
		 * Gets the url.
		 * 
		 * @return url
		 */
		public String getUrl() {
			return url;
		}

		/**
		 * Sets the current.
		 * 
		 * @param b
		 *            the b
		 */
		public void setCurrent(final boolean b) {
			isCurrent = b;
		}

		/**
		 * Sets the url.
		 * 
		 * @param string
		 *            the string
		 */
		public void setUrl(final String string) {
			url = string;
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#toString()
		 */
		@Override
		public String toString() {
			return getLabel();
		}
	}

	/**
	 * The Class PortletModeInfo.
	 */
	public static class PortletModeInfo implements Comparable<PortletModeInfo> {

		/** The name. */
		private String name;

		/** The url. */
		private String url;

		/** The is current. */
		private boolean isCurrent;

		/**
		 * Instantiates a new portlet mode info.
		 * 
		 * @param name
		 *            the name
		 * @param url
		 *            the url
		 * @param isCurrent
		 *            the is current
		 */
		public PortletModeInfo(final String name, final String url, final boolean isCurrent) {
			this.name = name;
			this.url = url;
			this.isCurrent = isCurrent;
		}

		/**
		 * Checks if is current.
		 * 
		 * @return current flag
		 */
		public boolean isCurrent() {
			return isCurrent;
		}

		/**
		 * Gets the name.
		 * 
		 * @return name
		 */
		public String getName() {
			return name;
		}

		/**
		 * Gets the url.
		 * 
		 * @return url
		 */
		public String getUrl() {
			return url;
		}

		/**
		 * Sets the current.
		 * 
		 * @param b
		 *            the b
		 */
		public void setCurrent(final boolean b) {
			isCurrent = b;
		}

		/**
		 * Sets the name.
		 * 
		 * @param string
		 *            the string
		 */
		public void setName(final String string) {
			name = string;
		}

		/**
		 * Sets the url.
		 * 
		 * @param string
		 *            the string
		 */
		public void setUrl(final String string) {
			url = string;
		}

		/**
		 * Compare to.
		 * 
		 * @param compare
		 *            the compare
		 * 
		 * @return the int
		 * 
		 * @see java.lang.Comparable#compareTo(java.lang.Object)
		 */
		@Override
		public int compareTo(final PortletModeInfo compare) {
			if (!(compare instanceof PortletModeInfo)) {
				throw new ClassCastException(compare + " is not a " + PortletModeInfo.class.getName());
			} else {
				final PortletModeInfo other = compare;
				return this.getName().compareTo(other.getName());
			}
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#toString()
		 */
		@Override
		public String toString() {
			return getName();
		}
	}

	/**
	 * Gets the error msg.
	 * 
	 * @return the error msg
	 */
	protected String getErrorMsg() {
		return PORTLET_ERROR_MSG;
	}
}
