/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.kportal.core.config.PropertyHelper;
import com.kportal.servlet.ExtensionServlet;
import com.univ.portail.util.PortletHelper;

// TODO: Auto-generated Javadoc
/**
 * The Class ServletRedirectPorlets.
 */
@WebServlet(name = "servletRedirectPorlets", urlPatterns = "/portlets/*", loadOnStartup = 1)
public class ServletRedirectPorlets extends ExtensionServlet {

	/**
	 *
	 */
	private static final long serialVersionUID = -8709818806286678838L;

	/** The Constant SEPARATEUR_URL. */
	private static final String SEPARATEUR_URL = "/";

	/* (non-Javadoc)
	 * @see javax.servlet.GenericServlet#getServletInfo()
	 */
	@Override
	public String getServletInfo() {
		return "portalImpl - Kportal Driver";
	}

	/* (non-Javadoc)
	 * @see javax.servlet.GenericServlet#init(javax.servlet.ServletConfig)
	 */
	@Override
	public void init(final ServletConfig config) throws ServletException {
		super.init(config);
	}

	/* (non-Javadoc)
	 * @see javax.servlet.GenericServlet#destroy()
	 */
	@Override
	public void destroy() {}

	/**
	 * Méthode permettant de récupérer le nom du contexte appelé.
	 *
	 * @param request
	 *            RequestedURI
	 *
	 * @return nom du contexte précédé de "/"
	 */
	private String recupererNomContexteDansRequest(final String request) {
		String contexte = request;
		//on retire le premier caractère qui est "/"
		contexte = request.substring(1);
		// on récupère le nom du contexte en extrayant la partie du texte qui va jusqu'au "/" suivant
		contexte = request.substring(0, contexte.indexOf(SEPARATEUR_URL) + 1);
		//on ajoute devant le contexte le "/" qui permet de l'appeler
		if (!contexte.startsWith(SEPARATEUR_URL)) {
			contexte = SEPARATEUR_URL + contexte;
		}
		return contexte;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	public void doGet(final HttpServletRequest servletRequest, final HttpServletResponse servletResponse) throws IOException, ServletException {
		final String redirection = servletRequest.getRequestURI().substring(PropertyHelper.getCoreProperty(PortletHelper.PARAM_PORTLET_PATH).length());
		//récupération du nom du contexte appelé.
		final String contexte = recupererNomContexteDansRequest(redirection);
		final String ressourceACharger = redirection.substring(contexte.length());
		//on récupère le contexte courant, et on appelle le contexte désiré à partir du contexte courant
		final ServletContext context = servletRequest.getSession(Boolean.FALSE).getServletContext().getContext(contexte);
		//on récupère un request dispatcher sr le contexte obtenu
		if (context != null) {
			final RequestDispatcher rd = context.getRequestDispatcher(ressourceACharger);
			if (rd != null) {
				rd.forward(servletRequest, servletResponse);
			} else {
				throw new ServletException("Impossible de charger les ressources suivantes: '" + ressourceACharger + "' sur le contexte: '" + contexte + "'.");
			}
		} else {
			throw new ServletException("le contexte '" + contexte + "' n'est pas accessible");
		}
	}

	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	public void doPost(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
		doGet(request, response);
	}

	@Override
	public boolean isActive() {
		return PortletHelper.isPortletActivated();
	}
}
