/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core;

import org.apache.pluto.portalImpl.factory.DynamicTitleServiceFactory;
import org.apache.pluto.portalImpl.factory.InformationProviderFactory;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderService;
import org.apache.pluto.services.information.StaticInformationProvider;
import org.apache.pluto.services.title.DynamicTitleService;

import com.univ.portail.service.factorymanager.FactoryManager;

// TODO: Auto-generated Javadoc
/**
 * The Class FactoryAccess.
 */
public class FactoryAccess {

	/**
	 * Gets the static provider.
	 * 
	 * @return the static provider
	 */
	public static StaticInformationProvider getStaticProvider() {
		return getProviderFactory().getStaticProvider();
	}

	/**
	 * Gets the dynamic provider.
	 * 
	 * @param request
	 *            the request
	 * 
	 * @return the dynamic provider
	 */
	public static DynamicInformationProvider getDynamicProvider(javax.servlet.http.HttpServletRequest request) {
		return getProviderFactory().getDynamicProvider(request);
	}

	/**
	 * Gets the information provider container service.
	 * 
	 * @return the information provider container service
	 */
	public static InformationProviderService getInformationProviderContainerService() {
		return getProviderService();
	}

	/**
	 * Gets the dynamic title container service.
	 * 
	 * @return the dynamic title container service
	 */
	public static DynamicTitleService getDynamicTitleContainerService() {
		return getDynTitleServiceFactory().getDynamicTitleService();
	}

	/**
	 * Gets the provider factory.
	 * 
	 * @return the provider factory
	 */
	private static InformationProviderFactory getProviderFactory() {
		return (InformationProviderFactory) FactoryManager.getFactory(InformationProviderFactory.class);
	}

	/**
	 * Gets the provider service.
	 * 
	 * @return the provider service
	 */
	private static InformationProviderService getProviderService() {
		return (InformationProviderService) FactoryManager.getFactory(InformationProviderFactory.class);
	}

	/**
	 * Gets the dyn title service factory.
	 * 
	 * @return the dyn title service factory
	 */
	private static DynamicTitleServiceFactory getDynTitleServiceFactory() {
		return (DynamicTitleServiceFactory) FactoryManager.getFactory(DynamicTitleServiceFactory.class);
	}
}
