/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core;

import java.util.Map;

import org.apache.pluto.portalImpl.factory.InformationProviderFactory;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderService;
import org.apache.pluto.services.information.StaticInformationProvider;

// TODO: Auto-generated Javadoc
/**
 * The Class InformationProviderServiceFactoryImpl.
 */
public class InformationProviderServiceFactoryImpl implements InformationProviderFactory, InformationProviderService {

	/** The servlet config. */
	private javax.servlet.ServletConfig servletConfig;

	// InformationProviderFactory implementation.
	// InformationProviderService implementation.
	/**
	 * Gets the static provider.
	 * 
	 * @return the static provider
	 */
	@Override
	public StaticInformationProvider getStaticProvider() {
		final javax.servlet.ServletContext context = servletConfig.getServletContext();
		StaticInformationProvider provider = (StaticInformationProvider) context.getAttribute("org.apache.pluto.portalImpl.StaticInformationProvider");
		if (provider == null) {
			provider = new StaticInformationProviderImpl(servletConfig);
			context.setAttribute("org.apache.pluto.portalImpl.StaticInformationProvider", provider);
		}
		return provider;
	}

	/**
	 * Gets the dynamic provider.
	 * 
	 * @param request
	 *            the request
	 * 
	 * @return the dynamic provider
	 */
	@Override
	public DynamicInformationProvider getDynamicProvider(final javax.servlet.http.HttpServletRequest request) {
		DynamicInformationProvider provider = (DynamicInformationProvider) request.getAttribute("org.apache.pluto.portalImpl.DynamicInformationProvider");
		if (provider == null) {
			provider = new DynamicInformationProviderImpl(request, servletConfig);
			request.setAttribute("org.apache.pluto.portalImpl.DynamicInformationProvider", provider);
		}
		return provider;
	}

	// additional methods.
	/**
	 * Inits the.
	 * 
	 * @param config
	 *            the config
	 * @param properties
	 *            the properties
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void init(final javax.servlet.ServletConfig config, final Map properties) throws Exception {
		servletConfig = config;
	}

	/**
	 * Destroy.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void destroy() throws Exception {}
}
