/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

import javax.portlet.PortletMode;
import javax.portlet.WindowState;

import org.apache.pluto.services.information.PortalContextProvider;

import com.univ.portail.service.config.Config;

// TODO: Auto-generated Javadoc
/**
 * The Class PortalContextProviderImpl.
 */
public class PortalContextProviderImpl implements PortalContextProvider {

	/** Portal information. */
	private String info = null;

	/** supported portlet modes by this portal. */
	private Vector<PortletMode> modes;

	/** supported window states by this portal. */
	private Vector<WindowState> states;

	/** portal properties. */
	private final HashMap<String, String> properties = new HashMap<String, String>();

	/**
	 * Instantiates a new portal context provider impl.
	 */
	public PortalContextProviderImpl() {
		// these are the minimum modes that the portal needs to support
		modes = getDefaultModes();
		// these are the minimum states that the portal needs to support
		states = getDefaultStates();
		// set info
		info = Config.getParameters().getString("portaldriver.info");
	}

	// PortalContextProvider implementation.
	/**
	 * Gets the property.
	 * 
	 * @param name
	 *            the name
	 * 
	 * @return the property
	 */
	@Override
	public java.lang.String getProperty(final java.lang.String name) {
		if (name == null) {
			throw new IllegalArgumentException("Property name == null");
		}
		return properties.get(name);
	}

	/**
	 * Gets the property names.
	 * 
	 * @return the property names
	 */
	@Override
	public java.util.Collection<String> getPropertyNames() {
		return properties.keySet();
	}

	/**
	 * Gets the supported portlet modes.
	 * 
	 * @return the supported portlet modes
	 */
	@Override
	public java.util.Collection<PortletMode> getSupportedPortletModes() {
		return modes;
	}

	/**
	 * Gets the supported window states.
	 * 
	 * @return the supported window states
	 */
	@Override
	public java.util.Collection<WindowState> getSupportedWindowStates() {
		return states;
	}

	/**
	 * Gets the portal info.
	 * 
	 * @return the portal info
	 */
	@Override
	public String getPortalInfo() {
		return info;
	}

	// internal methods.
	/**
	 * Gets the default modes.
	 * 
	 * @return the default modes
	 */
	private Vector<PortletMode> getDefaultModes() {
		final Vector<PortletMode> m = new Vector<PortletMode>();
		final String[] supportedModes = Config.getParameters().getStrings("supported.portletmode");
		for (final String supportedMode : supportedModes) {
			m.add(new PortletMode(supportedMode.toString().toLowerCase()));
		}
		return m;
	}

	/**
	 * Gets the default states.
	 * 
	 * @return the default states
	 */
	private Vector<WindowState> getDefaultStates() {
		final Vector<WindowState> s = new Vector<WindowState>();
		final String[] supportedStates = Config.getParameters().getStrings("supported.windowstate");
		for (final String supportedState : supportedStates) {
			s.add(new WindowState(supportedState.toString().toLowerCase()));
		}
		return s;
	}

	// additional methods.
	// methods used container internally to set
	/**
	 * Sets the property.
	 * 
	 * @param name
	 *            the name
	 * @param value
	 *            the value
	 */
	public void setProperty(final String name, final String value) {
		if (name == null) {
			throw new IllegalArgumentException("Property name == null");
		}
		properties.put(name, value);
	}

	// expects enumeration of PortletMode objects
	/**
	 * Sets the supported portlet modes.
	 * 
	 * @param portletModes
	 *            the new supported portlet modes
	 */
	public void setSupportedPortletModes(final Enumeration<PortletMode> portletModes) {
		final Vector<PortletMode> v = new Vector<PortletMode>();
		while (portletModes.hasMoreElements()) {
			v.add(portletModes.nextElement());
		}
		modes = v;
	}

	// expects enumeration of WindowState objects
	/**
	 * Sets the supported window states.
	 * 
	 * @param windowStates
	 *            the new supported window states
	 */
	public void setSupportedWindowStates(final Enumeration<WindowState> windowStates) {
		final Vector<WindowState> v = new Vector<WindowState>();
		while (windowStates.hasMoreElements()) {
			v.add(windowStates.nextElement());
		}
		states = v;
	}

	/**
	 * reset all values to default portlet modes and window states; delete all properties and set the given portlet information as portlet info string.
	 * 
	 * @param portalInfo
	 *            portal information string that will be returned by the <code>getPortalInfo</code> call.
	 */
	public void reset(final String portalInfo) {
		info = new String(portalInfo);
		// these are the minimum modes that the portal needs to support
		modes = getDefaultModes();
		// these are the minimum states that the portal needs to support
		states = getDefaultStates();
		properties.clear();
	}
}
