/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// TODO: Auto-generated Javadoc
/**
 * The Class PortalEnvironment.
 */
public class PortalEnvironment {

	/** The Constant REQUEST_PORTALENV. */
	public final static String REQUEST_PORTALENV = "org.apache.pluto.portalImpl.core.PortalEnvironment";

	/** The request. */
	private HttpServletRequest request;

	/** The response. */
	private HttpServletResponse response;

	/** The requested portal url. */
	private PortalURL requestedPortalURL;

	/** The portal control. */
	private PortalControlParameter portalControl;

	/**
	 * Instantiates a new portal environment.
	 * 
	 * @param request
	 *            the request
	 * @param response
	 *            the response
	 * @param config
	 *            the config
	 */
	public PortalEnvironment(HttpServletRequest request, HttpServletResponse response) {
		this.request = request;
		this.response = response;
		requestedPortalURL = new PortalURL(this);
		// get navigational information and prepare PortalURL object        
		requestedPortalURL.analyzeRequestInformation();
		portalControl = new PortalControlParameter(requestedPortalURL);
		// set Environment in Request for later use
		this.request.setAttribute(REQUEST_PORTALENV, this);
	}

	/**
	 * Gets the portal environment.
	 * 
	 * @param request
	 *            the request
	 * 
	 * @return the portal environment
	 */
	public static PortalEnvironment getPortalEnvironment(HttpServletRequest request) {
		return (PortalEnvironment) request.getAttribute(REQUEST_PORTALENV);
	}

	/**
	 * Gets the request.
	 * 
	 * @return the request
	 */
	public HttpServletRequest getRequest() {
		return request;
	}

	/**
	 * Gets the response.
	 * 
	 * @return the response
	 */
	public HttpServletResponse getResponse() {
		return response;
	}

	/*
	    public List getNavigationalInformation()
	    {
	        return navigationalInformation;
	    }
	*/
	/**
	 * Gets the requested portal url.
	 * 
	 * @return the requested portal url
	 */
	public PortalURL getRequestedPortalURL() {
		return requestedPortalURL;
	}

	/**
	 * Gets the portal control parameter.
	 * 
	 * @return the portal control parameter
	 */
	public PortalControlParameter getPortalControlParameter() {
		return portalControl;
	}

	/**
	 * Change requested portal url.
	 * 
	 * @param url
	 *            the url
	 * @param control
	 *            the control
	 */
	public void changeRequestedPortalURL(PortalURL url, PortalControlParameter control) {
		requestedPortalURL = url;
		requestedPortalURL.analyzeControlInformation(control);
		portalControl = control;
	}
}
