/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core;

import org.apache.pluto.PortletContainer;
import org.slf4j.LoggerFactory;

import com.univ.portail.service.config.Config;

// TODO: Auto-generated Javadoc
/**
 * A factory for creating PortletContainer objects.
 */
public class PortletContainerFactory {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(PortletContainerFactory.class);

	/** The Constant ENTRANCE_IMPL. */
	public static final String ENTRANCE_IMPL = "portletcontainer.entrance.impl";

	/** The Constant ENTRANCE_WRAPPER_IMPL. */
	public static final String ENTRANCE_WRAPPER_IMPL = "portletcontainer.entrance.wrapper.impl";

	/** The portlet container. */
	private static PortletContainer portletContainer;

	/** The portlet container wrapper. */
	private static PortletContainer portletContainerWrapper;
	static {
		try {
			portletContainer = (PortletContainer) Class.forName(Config.getParameters().getString(ENTRANCE_IMPL)).newInstance();
			portletContainerWrapper = (PortletContainer) Class.forName(Config.getParameters().getString(ENTRANCE_WRAPPER_IMPL)).newInstance();
		} catch (final IllegalAccessException e) {
			LOG.error("PortletContainerFactory.static constructor", e);
		} catch (final InstantiationException e) {
			LOG.error("PortletContainerFactory.static constructor", e);
		} catch (final ClassNotFoundException e) {
			LOG.error("PortletContainerFactory.static constructor", e);
		}
	}

	/**
	 * Gets the portlet container original.
	 * 
	 * @return the portlet container original
	 */
	static PortletContainer getPortletContainerOriginal() {
		return portletContainer;
	}

	/**
	 * Gets the portlet container.
	 * 
	 * @return the portlet container
	 */
	public static PortletContainer getPortletContainer() {
		return portletContainerWrapper;
	}
}
