/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core;

import java.io.IOException;
import java.util.Properties;

import javax.portlet.PortletException;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.PortletContainerEnvironment;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletContainerWrapperImpl.
 */
public class PortletContainerWrapperImpl implements PortletContainer {

	// PortletContainer implementation.
	/**
	 * Inits the.
	 * 
	 * @param uniqueContainerName
	 *            the unique container name
	 * @param servletConfig
	 *            the servlet config
	 * @param environment
	 *            the environment
	 * @param properties
	 *            the properties
	 * 
	 * @throws PortletContainerException
	 *             the portlet container exception
	 */
	@Override
	public void init(String uniqueContainerName, ServletConfig servletConfig, PortletContainerEnvironment environment, Properties properties) throws PortletContainerException {
		PortletContainerFactory.getPortletContainerOriginal().init(uniqueContainerName, servletConfig, environment, properties);
	}

	/**
	 * Shutdown.
	 * 
	 * @throws PortletContainerException
	 *             the portlet container exception
	 */
	@Override
	public void shutdown() throws PortletContainerException {
		PortletContainerFactory.getPortletContainerOriginal().shutdown();
	}

	/**
	 * Render portlet.
	 * 
	 * @param portletWindow
	 *            the portlet window
	 * @param servletRequest
	 *            the servlet request
	 * @param servletResponse
	 *            the servlet response
	 * 
	 * @throws PortletException
	 *             the portlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 * @throws PortletContainerException
	 *             the portlet container exception
	 */
	@Override
	public void renderPortlet(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, IOException,
		PortletContainerException {
		PortletContainerFactory.getPortletContainerOriginal().renderPortlet(portletWindow, servletRequest, servletResponse);
	}

	/**
	 * Process portlet action.
	 * 
	 * @param portletWindow
	 *            the portlet window
	 * @param servletRequest
	 *            the servlet request
	 * @param servletResponse
	 *            the servlet response
	 * 
	 * @throws PortletException
	 *             the portlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 * @throws PortletContainerException
	 *             the portlet container exception
	 */
	@Override
	public void processPortletAction(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, IOException,
		PortletContainerException {
		PortletContainerFactory.getPortletContainerOriginal().processPortletAction(portletWindow, servletRequest, servletResponse);
	}

	/**
	 * Portlet load.
	 * 
	 * @param portletWindow
	 *            the portlet window
	 * @param servletRequest
	 *            the servlet request
	 * @param servletResponse
	 *            the servlet response
	 * 
	 * @throws PortletException
	 *             the portlet exception
	 * @throws PortletContainerException
	 *             the portlet container exception
	 */
	@Override
	public void portletLoad(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, PortletContainerException {
		PortletContainerFactory.getPortletContainerOriginal().portletLoad(portletWindow, servletRequest, servletResponse);
	}

	/**
	 * Checks if is initialized.
	 * 
	 * @return true, if is initialized
	 */
	@Override
	public boolean isInitialized() {
		return PortletContainerFactory.getPortletContainerOriginal().isInitialized();
	}
}
