/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core;

import java.util.Iterator;
import java.util.Map;

import javax.portlet.PortletMode;
import javax.portlet.WindowState;

import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.PortletURLProvider;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletURLProviderImpl.
 */
public class PortletURLProviderImpl implements PortletURLProvider {

	/** The provider. */
	private final DynamicInformationProviderImpl provider;

	/** The portlet window. */
	private final PortletWindow portletWindow;

	/** The mode. */
	private PortletMode mode;

	/** The state. */
	private WindowState state;

	/** The action. */
	private boolean action;

	/** The secure. */
	private boolean secure;

	/** The clear parameters. */
	private boolean clearParameters;

	/** The parameters. */
	private Map parameters;

	/**
	 * Instantiates a new portlet url provider impl.
	 * 
	 * @param provider
	 *            the provider
	 * @param portletWindow
	 *            the portlet window
	 */
	public PortletURLProviderImpl(final DynamicInformationProviderImpl provider, final PortletWindow portletWindow) {
		this.provider = provider;
		this.portletWindow = portletWindow;
	}

	// PortletURLProvider implementation.
	/**
	 * Sets the portlet mode.
	 * 
	 * @param mode
	 *            the new portlet mode
	 */
	@Override
	public void setPortletMode(final PortletMode mode) {
		this.mode = mode;
	}

	/**
	 * Sets the window state.
	 * 
	 * @param state
	 *            the new window state
	 */
	@Override
	public void setWindowState(final WindowState state) {
		this.state = state;
	}

	/**
	 * Sets the action.
	 */
	@Override
	public void setAction() {
		action = true;
	}

	/**
	 * Sets the secure.
	 */
	@Override
	public void setSecure() {
		secure = true;
	}

	/**
	 * Clear parameters.
	 */
	@Override
	public void clearParameters() {
		clearParameters = true;
	}

	/**
	 * Sets the parameters.
	 * 
	 * @param parameters
	 *            the new parameters
	 */
	@Override
	public void setParameters(final Map parameters) {
		this.parameters = parameters;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final PortalURL url = PortalEnvironment.getPortalEnvironment(provider.request).getRequestedPortalURL();
		final PortalControlParameter controlURL = new PortalControlParameter(url);
		if (mode != null) {
			controlURL.setMode(portletWindow, mode);
		}
		if (state != null) {
			controlURL.setState(portletWindow, state);
		}
		if (clearParameters) {
			controlURL.clearRenderParameters(portletWindow);
		}
		// set portlet id for associated request parms
		controlURL.setPortletId(portletWindow);
		if (action) {
			controlURL.setAction(portletWindow);
		}
		if (parameters != null) {
			final Iterator<String> names = parameters.keySet().iterator();
			while (names.hasNext()) {
				final String name = names.next();
				final Object value = parameters.get(name);
				final String[] values = value instanceof String ? new String[] { (String) value } : (String[]) value;
				if (action) {
					//					controlURL.setRequestParam(NamespaceMapperAccess.getNamespaceMapper().encode(portletWindow.getId(), name),values);
					controlURL.setRequestParam(name, values);
				} else {
					controlURL.setRenderParam(portletWindow, name, values);
				}
			}
		}
		return url.toString(controlURL, new Boolean(secure));
	}
}
