/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.core;

import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.ResourceURLProvider;

import com.kportal.core.config.PropertyHelper;
import com.univ.portail.service.config.Config;
import com.univ.portail.util.PortletHelper;

// TODO: Auto-generated Javadoc
/**
 * The Class ResourceURLProviderImpl.
 */
public class ResourceURLProviderImpl implements ResourceURLProvider {

	/** The string url. */
	private String stringUrl = "";

	/** The base. */
	private final String base = "";

	/** The Constant insecureServlet. */
	private static final String insecureServlet;

	/** The Constant secureServlet. */
	private static final String secureServlet;
	static {
		insecureServlet = Config.getParameters().getString("servlet.insecure");
		secureServlet = Config.getParameters().getString("servlet.secure");
	}

	/**
	 * Instantiates a new resource url provider impl.
	 * 
	 * @param provider
	 *            the provider
	 * @param portletWindow
	 *            the portlet window
	 */
	public ResourceURLProviderImpl(final DynamicInformationProviderImpl provider, final PortletWindow portletWindow) {
		//        this.base = PortalURL.getBaseURLexcludeContext();
	}

	// ResourceURLProvider implementation.
	/**
	 * Sets the absolute url.
	 * 
	 * @param path
	 *            the new absolute url
	 */
	@Override
	public void setAbsoluteURL(final String path) {
		final String portletPath = PropertyHelper.getCoreProperty(PortletHelper.PARAM_PORTLET_PATH);
		if (portletPath != null && !"".equals(portletPath)) {
			stringUrl = portletPath + path;
		} else {
			stringUrl = path;
		}
	}

	/**
	 * Sets the full path.
	 * 
	 * @param path
	 *            the new full path
	 */
	@Override
	public void setFullPath(final String path) {
		stringUrl = base + path;
		/*        
		 * Ajout JSS 20060207 : le bridge JSF génèrait des urls de type /portlets/portal  pour
		 * les formulaires (et pas seulement pour les ressources)
		 * 
		 * cette méthode est donc également appelée pour les urls de type portail !!
		 * 
		 * */
		if (path.startsWith(insecureServlet) || path.startsWith(secureServlet)) {
			return;
		}
		final String portletPath = PropertyHelper.getCoreProperty(PortletHelper.PARAM_PORTLET_PATH);
		if (portletPath != null && !"".equals(portletPath)) {
			stringUrl = portletPath + path;
		} else {
			stringUrl = path;
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return stringUrl;
	}
}
