/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 9 mars 2006
 *
 */
package com.univ.portail.core;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

// TODO: Auto-generated Javadoc
/**
 * Stockage des paramètres statefull d'un portlet.
 * 
 * @author jeanseb
 */
public class SessionStatefullParameter {

	/**
	 * Save into session.
	 * 
	 * @param request
	 *            the request
	 * @param portletId
	 *            the portlet id
	 * @param controlsParameters
	 *            the controls parameters
	 */
	public static void saveIntoSession(HttpServletRequest request, String portletId, PortalControlParameter controlsParameters) {
		HttpSession session = request.getSession(Boolean.FALSE);
		//Log.debug("sauvegarde " +controlsParameters.getPIDValue() + " - " +   controlsParameters.getStateFullControlParameter() );
		session.setAttribute(portletId, controlsParameters.getStateFullControlParameter());
	}

	/**
	 * Gets the from session.
	 * 
	 * @param request
	 *            the request
	 * @param portletId
	 *            the portlet id
	 * 
	 * @return the from session
	 */
	public static Map getFromSession(HttpServletRequest request, String portletId) {
		HttpSession session = request.getSession(false);
		Map stateFullParameters = (Map) session.getAttribute(portletId);
		if (stateFullParameters != null) {
			//Log.debug("restauration " +portletId + " - " +  stateFullParameters );
		}
		return stateFullParameters;
	}
}
