/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core;

import javax.servlet.ServletConfig;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.services.information.PortalContextProvider;
import org.apache.pluto.services.information.StaticInformationProvider;

import com.univ.portail.service.registry.PortletDefinitionRegistry;

// TODO: Auto-generated Javadoc
/**
 * The Class StaticInformationProviderImpl.
 */
public class StaticInformationProviderImpl implements StaticInformationProvider {

	/** The provider. */
	private PortalContextProvider provider;

	/**
	 * Instantiates a new static information provider impl.
	 * 
	 * @param config
	 *            the config
	 */
	public StaticInformationProviderImpl(ServletConfig config) {
		// nothing do to
	}

	// StaticInformationProvider implementation.
	/**
	 * Gets the portal context provider.
	 * 
	 * @return the portal context provider
	 */
	@Override
	public PortalContextProvider getPortalContextProvider() {
		if (provider == null) {
			provider = new PortalContextProviderImpl();
		}
		return provider;
	}

	/**
	 * Gets the portlet definition.
	 * 
	 * @param portletGUID
	 *            the portlet guid
	 * 
	 * @return the portlet definition
	 */
	@Override
	public PortletDefinition getPortletDefinition(ObjectID portletGUID) {
		return PortletDefinitionRegistry.getPortletDefinition(portletGUID);
	}
}
