/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.core.factory;

import java.util.Map;

import org.apache.pluto.portalImpl.factory.DynamicTitleServiceFactory;
import org.apache.pluto.services.title.DynamicTitleService;

import com.univ.portail.core.impl.DynamicTitleServiceImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class DynamicTitleServiceFactoryImpl.
 */
public class DynamicTitleServiceFactoryImpl implements DynamicTitleServiceFactory {

	/**
	 * Gets the dynamic title service.
	 * 
	 * @return the dynamic title service
	 */
	@Override
	public DynamicTitleService getDynamicTitleService() {
		return new DynamicTitleServiceImpl();
	}

	// additional methods
	/**
	 * Inits the.
	 * 
	 * @param config
	 *            the config
	 * @param properties
	 *            the properties
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void init(final javax.servlet.ServletConfig config, final Map properties) throws Exception {
		// nothing to do
	}

	/**
	 * Destroy.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void destroy() throws Exception {
		// nothing to do
	}
}
