/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core.factory;

import javax.portlet.PortletPreferences;

import org.apache.pluto.factory.PortletPreferencesFactory;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.PortletDefinition;

import com.univ.portail.core.impl.PortletPreferencesImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletPreferencesFactoryImpl.
 */
public class PortletPreferencesFactoryImpl implements PortletPreferencesFactory {

	/**
	 * Inits the.
	 * 
	 * @param config
	 *            the config
	 * @param properties
	 *            the properties
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void init(javax.servlet.ServletConfig config, java.util.Map properties) throws Exception {}

	// org.apache.pluto.factory.PortletPreferencesFactory -----------------------------------------
	/**
	 * Gets the portlet preferences.
	 * 
	 * @param methodId
	 *            the method id
	 * @param portletEntity
	 *            the portlet entity
	 * 
	 * @return the portlet preferences
	 */
	@Override
	public PortletPreferences getPortletPreferences(Integer methodId, PortletEntity portletEntity) {
		return new PortletPreferencesImpl(methodId, portletEntity);
	}

	/**
	 * Gets the portlet preferences.
	 * 
	 * @param methodId
	 *            the method id
	 * @param portletDefinition
	 *            the portlet definition
	 * 
	 * @return the portlet preferences
	 */
	@Override
	public PortletPreferences getPortletPreferences(Integer methodId, PortletDefinition portletDefinition) {
		return new PortletPreferencesImpl(methodId, portletDefinition);
	}

	// --------------------------------------------------------------------------------------------
	// additional methods -------------------------------------------------------------------------
	/**
	 * Destroy.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void destroy() throws Exception {}
	// --------------------------------------------------------------------------------------------
}
