/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.core.factory;

import javax.portlet.RenderRequest;

import org.apache.pluto.factory.RenderRequestFactory;
import org.apache.pluto.om.window.PortletWindow;

import com.univ.portail.core.impl.RenderRequestImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class RenderRequestFactoryImpl.
 */
public class RenderRequestFactoryImpl implements RenderRequestFactory {

	/**
	 * Inits the.
	 * 
	 * @param config
	 *            the config
	 * @param properties
	 *            the properties
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void init(javax.servlet.ServletConfig config, java.util.Map properties) throws Exception {}

	// org.apache.pluto.factory.RenderRequestFactory implementation -------------------------------
	/**
	 * Gets the render request.
	 * 
	 * @param portletWindow
	 *            the portlet window
	 * @param servletRequest
	 *            the servlet request
	 * @param servletResponse
	 *            the servlet response
	 * 
	 * @return the render request
	 */
	@Override
	public RenderRequest getRenderRequest(PortletWindow portletWindow, javax.servlet.http.HttpServletRequest servletRequest, javax.servlet.http.HttpServletResponse servletResponse) {
		RenderRequest renderRequest = new RenderRequestImpl(portletWindow, servletRequest);
		return renderRequest;
	}

	// --------------------------------------------------------------------------------------------
	// additional methods -------------------------------------------------------------------------
	/**
	 * Destroy.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void destroy() throws Exception {}
	// --------------------------------------------------------------------------------------------
}
