/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

import org.apache.pluto.core.impl.PortletRequestImpl;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.om.window.PortletWindow;

import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.objetspartages.om.InfosPreferences;
import com.univ.portail.om.user.UserPreference;
import com.univ.utils.ContexteUniv;

// TODO: Auto-generated Javadoc
/**
 * To change this generated comment edit the template variable "typecomment": Window>Preferences>Java>Templates. To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ActionRequestImpl extends PortletRequestImpl implements ActionRequest {

	/** Holds the portlet preferences. */
	private PortletPreferences portletPreferences;

	/** The user preferences. */
	private UserPreference userPreferences = null;

	/** The id service. */
	private String idService = null;

	/** The user code. */
	private String userCode = null;

	/**
	 * Instantiates a new action request impl.
	 * 
	 * @param portletWindow
	 *            the portlet window
	 * @param servletRequest
	 *            the servlet request
	 */
	public ActionRequestImpl(final PortletWindow portletWindow, final javax.servlet.http.HttpServletRequest servletRequest) {
		super(portletWindow, servletRequest);
		// Récupération des préférences personnelles de l'utilisateur connecté
		// liées à ce service..
		idService = portletWindow.getPortletEntity().getId().toString();
		final SessionUtilisateur sessionKportal = (SessionUtilisateur) servletRequest.getSession(Boolean.FALSE).getAttribute(
			SessionUtilisateur.CLE_SESSION_UTILISATEUR_DANS_SESSION_HTTP);
		if (sessionKportal != null) {
			final ContexteUniv ctx = (ContexteUniv) servletRequest.getAttribute("kportal.ctx");
			userCode = ctx.getCode();
			//Map des user Attributes
			servletRequest.setAttribute(PortletRequest.USER_INFO, KportalContexteUtil.getUserPorltetInfos(ctx));
			userPreferences = sessionKportal.getUserPreferences();
		}
	}

	// javax.portlet.ActionRequest implementation -------------------------------------------------
	/* (non-Javadoc)
	 * @see org.apache.pluto.core.InternalActionResponse#getPortletInputStream()
	 */
	/**
	 * Gets the portlet input stream.
	 * 
	 * @return the portlet input stream
	 * 
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	public InputStream getPortletInputStream() throws java.io.IOException {
		final javax.servlet.http.HttpServletRequest servletRequest = (javax.servlet.http.HttpServletRequest) super.getRequest();
		if (servletRequest.getMethod().equals("POST")) {
			final String contentType = servletRequest.getContentType();
			if (contentType == null || contentType.equals("application/x-www-form-urlencoded")) {
				throw new java.lang.IllegalStateException(
					"User request HTTP POST data is of type application/x-www-form-urlencoded. This data has been already processed by the portal/portlet-container and is available as request parameters.");
			}
		}
		return servletRequest.getInputStream();
	}

	/**
	 * Gets the remote user.
	 * 
	 * @return the remote user
	 */
	@Override
	public String getRemoteUser() {
		return userCode;
	}

	// --------------------------------------------------------------------------------------------
	// PortletRequestImpl implementation ----------------------------------------------------------
	/**
	 * Gets the preferences.
	 * 
	 * @return the preferences
	 */
	@Override
	public PortletPreferences getPreferences() {
		if (this.portletPreferences == null) {
			this.portletPreferences = PortletObjectAccess.getPortletPreferences(org.apache.pluto.Constants.METHOD_ACTION, super.getInternalPortletWindow().getPortletEntity());
			// on ajoute les préférences utilisateur si elles sont présentes
			// dans la portletSession.
			// on récupère les portlets préférences dans la portletSession
			if (userPreferences != null) {
				((PortletPreferencesImpl) portletPreferences).setUserPreferences(userPreferences);
				final List<InfosPreferences> listeUserPref = userPreferences.getUserPreferencesFromService(idService);
				if (listeUserPref != null) {
					for (final Object element : listeUserPref) {
						final InfosPreferences infoPref = (InfosPreferences) element;
						((PortletPreferencesImpl) portletPreferences).setUserValues(infoPref.getNom(), infoPref.getValeursAsList());
					}
				}
			}
		}
		return this.portletPreferences;
	}
	// --------------------------------------------------------------------------------------------
}
