/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.core.impl;

import javax.servlet.http.HttpServletRequest;

import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.title.DynamicTitleService;

// TODO: Auto-generated Javadoc
/**
 * The Class DynamicTitleServiceImpl.
 */
public class DynamicTitleServiceImpl implements DynamicTitleService {

	/**
	 * Instantiates a new dynamic title service impl.
	 */
	public DynamicTitleServiceImpl() {}

	/**
	 * Sets the dynamic title.
	 * 
	 * @param window
	 *            the window
	 * @param request
	 *            the request
	 * @param dynamicTitle
	 *            the dynamic title
	 */
	@Override
	public void setDynamicTitle(PortletWindow window, HttpServletRequest request, String dynamicTitle) {
		request.setAttribute("org.apache.pluto.dynamic_title" + window.getId().toString(), dynamicTitle);
	}

	/**
	 * Gets the dynamic title.
	 * 
	 * @param window
	 *            the window
	 * @param request
	 *            the request
	 * 
	 * @return the dynamic title
	 */
	public String getDynamicTitle(PortletWindow window, HttpServletRequest request) {
		return (String) request.getAttribute("org.apache.pluto.dynamic_title" + window.getId().toString());
	}
}
