/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.core.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.univ.utils.ContexteUniv;

/**
 * The Class KportalContexteUtil.
 */
public final class KportalContexteUtil {

	/**
	 * Méthode retournant les informations relatives à l'utilisateur et accessibles depuis une portlet via la clé <code>USER_INFOS</code>. Ces informations sont obtenues depuis
	 * l'objet <code>com.univ.utils.ContexteUniv</code> passé en paramètre. <br/>
	 * Cette méthode retourne une <code>java.util.Map</code> contenant les informations accessibles depuis les clés suivantes:
	 * <ul>
	 * <li>user.name.given</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code> : prénom de l'utilisateur</li>
	 * <li><code>user.name.family</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code>: nom de l'utilisateur</li>
	 * <li><code>user.business-info.online.email</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>String</code> : email de l'utilisateur</li>
	 * <li><code>user.department</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code> : code structure</li>
	 * <li><code>kportal.utilisateur.code</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code> : code de l'utilisateur</li>
	 * <li><code>kportal.utilisateur.code_gestion</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code> : login (code ldap)</li>
	 * <li><code>kportal.utilisateur.nom</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code> nom de l'utilisateur</li>
	 * <li><code>kportal.utilisateur.prenom</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code> prénom de l'utilisateur</li>
	 * <li><code>kportal.utilisateur.mail</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code> : mail de l'utilisateur</li>
	 * <li><code>kportal.utilisateur.groupes</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.util.Set</code> : groupes de l'utilisateur</li>
	 * <li><code>kportal.utilisateur.profils</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.util.Set</code> : profils de l'utilisateur</li>
	 * <li><code>kportal.utilisateur.espaces</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.util.Set</code> : espaces collaboratifs de
	 * l'utilisateur</li>
	 * <li><code>kportal.utilisateur.structure</code> (<code>java.lang.String</code>) donnant accès à un objet de type <code>java.lang.String</code> : structure de l'utilisateur</li>
	 * </ul>
	 * 
	 * @param ctx
	 *            contexte Univ à partir duquel on obtient toutes les informations
	 * 
	 * @return Map permettant d'accéder aux informations
	 */
	public static Map<String, Serializable> getUserPorltetInfos(ContexteUniv ctx) {
		Map<String, Serializable> tableInfos = new HashMap<String, Serializable>();
		tableInfos.put("user.name.given", ctx.getPrenom());
		tableInfos.put("user.name.family", ctx.getNom());
		tableInfos.put("user.business-info.online.email", ctx.getAdresseMail());
		tableInfos.put("user.department", ctx.getCodeStructure());
		//infos spécifiques Kportal
		tableInfos.put("kportal.utilisateur.code", ctx.getCode());
		tableInfos.put("kportal.utilisateur.code_gestion", ctx.getCodeGestion());
		tableInfos.put("kportal.utilisateur.nom", ctx.getNom());
		tableInfos.put("kportal.utilisateur.prenom", ctx.getPrenom());
		tableInfos.put("kportal.utilisateur.mail", ctx.getAdresseMail());
		tableInfos.put("kportal.utilisateur.groupes", ctx.getGroupesDsiAvecAscendants());
		tableInfos.put("kportal.utilisateur.profils", ctx.getListeProfilsDsi());
		tableInfos.put("kportal.utilisateur.structure", ctx.getCodeStructure());
		return tableInfos;
	}
}
