/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.core.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;

import org.apache.pluto.PortletContainerServices;
import org.apache.pluto.core.impl.PortletRequestImpl;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.log.LogService;
import org.apache.pluto.services.log.Logger;

import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.objetspartages.om.InfosPreferences;
import com.univ.portail.om.user.UserPreference;
import com.univ.utils.ContexteUniv;

// TODO: Auto-generated Javadoc
/**
 * To change this generated comment edit the template variable "typecomment": Window>Preferences>Java>Templates. To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class RenderRequestImpl extends PortletRequestImpl implements RenderRequest {

	/** Holds the portlet preferences. */
	private PortletPreferences portletPreferences = null;

	/** The log. */
	private Logger log = null;

	/** The user preferences. */
	private UserPreference userPreferences = null;

	/** The id service. */
	private String idService = null;

	/** The user code. */
	private String userCode = null;

	/**
	 * Instantiates a new render request impl.
	 * 
	 * @param portletWindow
	 *            the portlet window
	 * @param servletRequest
	 *            the servlet request
	 */
	public RenderRequestImpl(final PortletWindow portletWindow, final javax.servlet.http.HttpServletRequest servletRequest) {
		super(portletWindow, servletRequest);
		this.log = ((LogService) PortletContainerServices.get(LogService.class)).getLogger(getClass());
		// Récupération des préférences personnelles de l'utilisateur connecté
		// liées à ce service..
		idService = portletWindow.getPortletEntity().getId().toString();
		final SessionUtilisateur sessionKportal = (SessionUtilisateur) servletRequest.getSession(Boolean.FALSE).getAttribute(
			SessionUtilisateur.CLE_SESSION_UTILISATEUR_DANS_SESSION_HTTP);
		if (sessionKportal != null) {
			final ContexteUniv ctx = (ContexteUniv) servletRequest.getAttribute("kportal.ctx");
			userCode = ctx.getCode();
			//Map des user Attributes
			servletRequest.setAttribute(PortletRequest.USER_INFO, KportalContexteUtil.getUserPorltetInfos(ctx));
			userPreferences = sessionKportal.getUserPreferences();
		}
	}

	// additional methods
	// -------------------------------------------------------------------------
	/**
	 * Gets the reader.
	 * 
	 * @return the reader
	 * 
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 * 
	 * @see javax.servlet.ServletRequest#getReader()
	 */
	@Override
	public BufferedReader getReader() throws IOException {
		return super.getReader();
	}

	/**
	 * Gets the remote user.
	 * 
	 * @return the remote user
	 */
	@Override
	public String getRemoteUser() {
		return userCode;
	}

	/**
	 * Gets the preferences.
	 * 
	 * @return the preferences
	 */
	@Override
	public PortletPreferences getPreferences() {
		if (log.isDebugEnabled()) {
			log.debug("Getting Preferences: " + portletPreferences);
		}
		if (portletPreferences == null) {
			portletPreferences = PortletObjectAccess.getPortletPreferences(org.apache.pluto.Constants.METHOD_RENDER, super.getInternalPortletWindow().getPortletEntity());
			// on ajoute les préférences utilisateur si elles sont présentes
			// dans la portletSession.
			// on récupère les portlets préférences dans la portletSession
			if (userPreferences != null) {
				((PortletPreferencesImpl) portletPreferences).setUserPreferences(userPreferences);
				final List<InfosPreferences> listeUserPref = userPreferences.getUserPreferencesFromService(idService);
				if (listeUserPref != null) {
					for (final InfosPreferences infosPreferences : listeUserPref) {
						final InfosPreferences infoPref = infosPreferences;
						((PortletPreferencesImpl) portletPreferences).setUserValues(infoPref.getNom(), infoPref.getValeursAsList());
					}
				}
			}
		}
		if (log.isDebugEnabled()) {
			log.debug("Returning Preferences: " + portletPreferences);
			final Enumeration<String> e = portletPreferences.getNames();
			while (e.hasMoreElements()) {
				final String name = e.nextElement();
				log.debug(" - Preference: name = " + name);
			}
		}
		return portletPreferences;
	}
	// --------------------------------------------------------------------------------------------
}
