/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.deploiment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.slf4j.LoggerFactory;

// TODO: Auto-generated Javadoc
/**
 * this deployment utility has been deprecated in favor of the one provided with the deploy subproject.
 *
 * @see org.apache.pluto.driver.deploy.CLI
 */
public class Deploy {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(Deploy.class);

	/** The debug. */
	private static boolean debug = false;

	/** The dir delim. */
	private static String dirDelim = System.getProperty("file.separator");

	/** The web apps dir. */
	private static String webAppsDir;

	/** The portal impl web dir. */
	private static String portalImplWebDir;

	/** The pluto home. */
	private static String plutoHome;

	/**
	 * Deploy archive.
	 *
	 * @param webAppsDir
	 *            the web apps dir
	 * @param warFile
	 *            the war file
	 *
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	public static void deployArchive(final String webAppsDir, final String warFile) throws IOException {
		String warFileName = warFile;
		if (warFileName.indexOf("/") != -1) {
			warFileName = warFileName.substring(warFileName.lastIndexOf("/") + 1);
		}
		if (warFileName.indexOf(dirDelim) != -1) {
			warFileName = warFileName.substring(warFileName.lastIndexOf(dirDelim) + 1);
		}
		if (warFileName.endsWith(".war")) {
			warFileName = warFileName.substring(0, warFileName.lastIndexOf("."));
		}
		LOG.info("deploying '" + warFileName + "' ...");
		final String destination = webAppsDir + warFileName;
		final JarFile jarFile = new JarFile(warFile);
		final Enumeration<JarEntry> files = jarFile.entries();
		while (files.hasMoreElements()) {
			final JarEntry entry = files.nextElement();
			/* Check for use of '/WEB-INF/tld/portlet.tld' instead of 'http://java.sun.com/portlet' in taglib declaration*/
			final String fileName = entry.getName();
			if (!entry.isDirectory() && entry.getName().endsWith(".jsp")) {
				final InputStream is = jarFile.getInputStream(entry);
				final Reader r = new BufferedReader(new InputStreamReader(is));
				final StreamTokenizer st = new StreamTokenizer(r);
				st.quoteChar('\'');
				st.quoteChar('"');
				while (st.nextToken() != StreamTokenizer.TT_EOF) {
					if (st.ttype == '\'' || st.ttype == '"') {
						final String sval = st.sval;
						final String sqc = Character.toString((char) st.ttype);
						if (sval.equals("/WEB-INF/tld/portlet.tld")) {
							LOG.warn("Warning: " + sqc + st.sval + sqc + " has been found in file " + fileName + ". Use instead " + sqc + "http://java.sun.com/portlet" + sqc + " with your portlet taglib declaration!\n");
							break;
						}
					}
				}
			}
			final File file = new File(destination, fileName);
			final File dirF = new File(file.getParent());
			dirF.mkdirs();
			if (entry.isDirectory()) {
				file.mkdirs();
			} else {
				final byte[] buffer = new byte[1024];
				int length = 0;
				final InputStream fis = jarFile.getInputStream(entry);
				final FileOutputStream fos = new FileOutputStream(file);
				while ((length = fis.read(buffer)) >= 0) {
					fos.write(buffer, 0, length);
				}
				fos.close();
			}
		}
		jarFile.close();
		System.out.println("finished!");
	}

	/**
	 * The main method.
	 *
	 * @param args
	 *            the arguments
	 */
	public static void main(final String args[]) {
		String warFile;
		if (args.length < 2) {
			System.out.println("No argument specified. This command must be issued as:");
			System.out.println("deploy <TOMCAT-webapps-directory> <web-archive>");
			return;
		}
		if (args.length > 4) {
			if ((args[4].equals("-debug")) || (args[4].equals("/debug"))) {
				debug = true;
			}
		}
		if (debug) {
			for (int i = 0; i < args.length; i++) {
				System.out.println("args[" + i + "]:" + args[i]);
			}
		}
		webAppsDir = args[0];
		if (!webAppsDir.endsWith(dirDelim)) {
			webAppsDir += dirDelim;
		}
		portalImplWebDir = args[1];
		if (!portalImplWebDir.endsWith(dirDelim)) {
			portalImplWebDir += dirDelim;
		}
		warFile = args[2];
		plutoHome = args[3];
		if (!plutoHome.endsWith(dirDelim)) {
			plutoHome += dirDelim;
		}
		try {
			deployArchive(plutoHome, warFile);
		} catch (final PlutoAdminException e) {
			throw e;
		} catch (final Exception e) {
			LOG.error("Error found in Deploy.main()", e);
			throw new PlutoAdminException("Error found in Deploy.main()", e);
		}
	}
}
