/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.definition.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionList;
import org.apache.pluto.om.servlet.WebApplicationDefinition;
import org.apache.pluto.portalImpl.om.common.Support;
import org.apache.pluto.util.StringUtils;

import com.univ.portail.om.servlet.impl.WebApplicationDefinitionImpl;
import com.univ.portail.util.ObjectIDImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletApplicationDefinitionImpl.
 */
public class PortletApplicationDefinitionImpl implements PortletApplicationDefinition, java.io.Serializable, Support {

	/**
	 *
	 */
	private static final long serialVersionUID = 8059271211790965096L;

	/** The GUID. */
	private String GUID = null;

	/** The app id. */
	private String appId = null;

	/** The version. */
	private String version = null;

	/** The custom portlet mode. */
	private ArrayList<?> customPortletMode = new ArrayList<Object>();

	/** The custom portlet state. */
	private ArrayList<?> customPortletState = new ArrayList<Object>();

	/** The user attribute. */
	private ArrayList<?> userAttribute = new ArrayList<Object>();

	/** The security constraint. */
	private ArrayList<?> securityConstraint = new ArrayList<Object>();

	/** The portlets. */
	private final PortletDefinitionList portlets = new PortletDefinitionListImpl();

	/** The web application. */
	private WebApplicationDefinition webApplication = null;

	/** The object id. */
	private ObjectID objectId = null;

	/** The context path. */
	private String contextPath = null;

	// PortletApplicationDefinition implementation.
	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Override
	public ObjectID getId() {
		if (objectId == null) {
			objectId = ObjectIDImpl.createFromString(getGUID());
		}
		return objectId;
	}

	/**
	 * Gets the version.
	 *
	 * @return the version
	 */
	@Override
	public String getVersion() {
		return version;
	}

	/**
	 * Gets the portlet definition list.
	 *
	 * @return the portlet definition list
	 */
	@Override
	public PortletDefinitionList getPortletDefinitionList() {
		return portlets;
	}

	/**
	 * Gets the web application definition.
	 *
	 * @return the web application definition
	 */
	@Override
	public WebApplicationDefinition getWebApplicationDefinition() {
		return webApplication;
	}

	// Support implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postLoad(java.lang.Object)
	 */
	@Override
	public void postLoad(final Object parameter) throws Exception {
		((Support) portlets).postLoad(parameter);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preBuild(java.lang.Object)
	 */
	@Override
	public void preBuild(final Object parameter) throws Exception {
		@SuppressWarnings("unchecked")
		final Vector<Object> structure = (Vector<Object>) parameter;
		final String contextRoot = (String) structure.get(0);
		final WebApplicationDefinition webApplication = (WebApplicationDefinition) structure.get(1);
		final Map<?, ?> servletMap = (Map<?, ?>) structure.get(2);
		setContextRoot(contextRoot);
		setWebApplicationDefinition(webApplication);
		final Vector<Object> structure2 = new Vector<Object>();
		structure2.add(this);
		structure2.add(servletMap);
		((Support) portlets).preBuild(structure2);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postBuild(java.lang.Object)
	 */
	@Override
	public void postBuild(final Object parameter) throws Exception {}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preStore(java.lang.Object)
	 */
	@Override
	public void preStore(final Object parameter) throws Exception {
		((Support) portlets).preStore(parameter);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postStore(java.lang.Object)
	 */
	@Override
	public void postStore(final Object parameter) throws Exception {
		((Support) portlets).postStore(parameter);
	}

	// internal methods.
	/**
	 * Gets the gUID.
	 *
	 * @return the gUID
	 */
	private String getGUID() {
		if (GUID == null) {
			GUID = "";
			String id = "";
			if (webApplication != null) {
				id = webApplication.getContextRoot();
			} else {
				id = contextPath;
			}
			if (id != null) {
				if (id.startsWith("/")) {
					id = id.substring(id.indexOf("/") + 1);
				}
				GUID += id;
			}
		}
		return GUID;
	}

	/**
	 * Sets the context root.
	 *
	 * @param contextRoot
	 *            the new context root
	 */
	private void setContextRoot(String contextRoot) {
		// Test for IBM WebSphere
		if (contextRoot != null && contextRoot.endsWith(".war")) {
			contextRoot = contextRoot.substring(0, contextRoot.length() - 4);
		}
		this.contextPath = contextRoot;
	}

	// additional methods.
	/**
	 * Gets the app id.
	 *
	 * @return the app id
	 */
	public String getAppId() {
		return appId;
	}

	/**
	 * Sets the app id.
	 *
	 * @param appId
	 *            the new app id
	 */
	public void setAppId(final String appId) {
		this.appId = appId;
	}

	/**
	 * Sets the version.
	 *
	 * @param version
	 *            the new version
	 */
	public void setVersion(final String version) {
		this.version = version;
	}

	// not yet fully supported:
	/**
	 * Gets the custom portlet mode.
	 *
	 * @return the custom portlet mode
	 */
	public Collection<?> getCustomPortletMode() {
		return customPortletMode;
	}

	/**
	 * Sets the custom portlet mode.
	 *
	 * @param customPortletMode
	 *            the new custom portlet mode
	 */
	public void setCustomPortletMode(final Collection<?> customPortletMode) {
		this.customPortletMode = (ArrayList<?>) customPortletMode;
	}

	/**
	 * Gets the custom portlet state.
	 *
	 * @return the custom portlet state
	 */
	public Collection<?> getCustomPortletState() {
		return customPortletState;
	}

	/**
	 * Sets the custom portlet state.
	 *
	 * @param customPortletState
	 *            the new custom portlet state
	 */
	public void setCustomPortletState(final Collection<?> customPortletState) {
		this.customPortletState = (ArrayList<?>) customPortletState;
	}

	/**
	 * Gets the user attribute.
	 *
	 * @return the user attribute
	 */
	public Collection<?> getUserAttribute() {
		return userAttribute;
	}

	/**
	 * Sets the user attribute.
	 *
	 * @param userAttribute
	 *            the new user attribute
	 */
	public void setUserAttribute(final Collection<?> userAttribute) {
		this.userAttribute = (ArrayList<?>) userAttribute;
	}

	/**
	 * Gets the security constraint.
	 *
	 * @return the security constraint
	 */
	public Collection<?> getSecurityConstraint() {
		return securityConstraint;
	}

	/**
	 * Sets the security constraint.
	 *
	 * @param securityConstraint
	 *            the new security constraint
	 */
	public void setSecurityConstraint(final Collection<?> securityConstraint) {
		this.securityConstraint = (ArrayList<?>) securityConstraint;
	}

	// additional internal methods
	/**
	 * Gets the castor portlets.
	 *
	 * @return the castor portlets
	 */
	public Collection<?> getCastorPortlets() {
		return (PortletDefinitionListImpl) portlets;
	}

	/**
	 * Sets the web application definition.
	 *
	 * @param webApplication
	 *            the new web application definition
	 */
	protected void setWebApplicationDefinition(final WebApplicationDefinition webApplication) {
		this.webApplication = webApplication;
	}

	// internal methods used for debugging purposes only
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(":");
		StringUtils.newLine(buffer, indent);
		buffer.append("{");
		StringUtils.newLine(buffer, indent);
		buffer.append("objectID='");
		buffer.append(getId().toString());
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("GUID='");
		buffer.append(GUID);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("version='");
		buffer.append(version);
		buffer.append("'");
		@SuppressWarnings("unchecked")
		final Iterator<PortletDefinitionImpl> iterator = portlets.iterator();
		if (iterator.hasNext()) {
			StringUtils.newLine(buffer, indent);
			buffer.append("Portlets:");
		}
		while (iterator.hasNext()) {
			buffer.append(iterator.next().toString(indent + 2));
		}
		if (webApplication != null) {
			StringUtils.newLine(buffer, indent);
			buffer.append("webApplication:");
			buffer.append(((WebApplicationDefinitionImpl) webApplication).toString(indent + 2));
		}
		StringUtils.newLine(buffer, indent);
		buffer.append("}");
		return buffer.toString();
	}
}
