/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.definition.impl;

import java.util.HashSet;
import java.util.Iterator;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletApplicationDefinitionList;
import org.apache.pluto.util.StringUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletApplicationDefinitionListImpl.
 */
public class PortletApplicationDefinitionListImpl extends HashSet<PortletApplicationDefinition> implements PortletApplicationDefinitionList, java.io.Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -5041680494445247880L;

	//    private static ServiceChargementPorltetsDefinition serviceDefinition
	//     = (ServiceChargementPorltetsDefinition) ServiceManager.getService(ServiceChargementPorltetsDefinition.class);
	/**
	 * Instantiates a new portlet application definition list impl.
	 */
	public PortletApplicationDefinitionListImpl() {}

	// PortletApplicationDefinitionList implementation.
	/**
	 * Gets the.
	 *
	 * @param objectId
	 *            the object id
	 *
	 * @return the portlet application definition
	 */
	@Override
	public PortletApplicationDefinition get(final ObjectID objectId) {
		final Iterator<PortletApplicationDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletApplicationDefinition portletApplicationDefinition = iterator.next();
			if (portletApplicationDefinition.getId().equals(objectId)) {
				return portletApplicationDefinition;
			}
		}
		return null;
	}

	// additional internal methods
	/**
	 * Gets the.
	 *
	 * @param objectId
	 *            the object id
	 *
	 * @return the portlet application definition
	 */
	public PortletApplicationDefinition get(final String objectId) {
		final Iterator<PortletApplicationDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletApplicationDefinition portletApplicationDefinition = iterator.next();
			if (portletApplicationDefinition.getId().toString().equals(objectId)) {
				return portletApplicationDefinition;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see java.util.AbstractCollection#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(": ");
		final Iterator<PortletApplicationDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			buffer.append(((PortletApplicationDefinitionImpl) iterator.next()).toString(indent + 2));
		}
		return buffer.toString();
	}
}
