/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.definition.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;

import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.DescriptionSet;
import org.apache.pluto.om.common.DisplayName;
import org.apache.pluto.om.common.DisplayNameSet;
import org.apache.pluto.om.common.LanguageSet;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.ParameterSet;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.common.SecurityRoleRefSet;
import org.apache.pluto.om.portlet.ContentTypeSet;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionCtrl;
import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.portalImpl.om.common.Support;
import org.apache.pluto.portalImpl.om.common.impl.DescriptionSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.DisplayNameSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.LanguageSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.ParameterSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.SecurityRoleRefSetImpl;
import org.apache.pluto.portalImpl.om.portlet.impl.ContentTypeSetImpl;
import org.apache.pluto.util.StringUtils;

import com.univ.portail.om.servlet.impl.ServletDefinitionImpl;
import com.univ.portail.util.ObjectIDImpl;
import com.univ.portail.util.PreferenceSetImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletDefinitionImpl.
 */
public class PortletDefinitionImpl implements PortletDefinition, PortletDefinitionCtrl, java.io.Serializable, Support {

	/**
	 *
	 */
	private static final long serialVersionUID = 4375043528273414259L;

	/** The application. */
	private PortletApplicationDefinition application = null;

	/** The castor resources. */
	private LanguageSet castorResources = null;

	// contains String objects
	/** The castor supported locales. */
	private ArrayList<String> castorSupportedLocales = new ArrayList<String>();

	/** The class loader. */
	private ClassLoader classLoader = null;

	/** The class name. */
	private String className = null;

	/** The content types. */
	private ContentTypeSet contentTypes = new ContentTypeSetImpl();

	/** The descriptions. */
	private DescriptionSet descriptions = new DescriptionSetImpl();

	/** The display names. */
	private DisplayNameSet displayNames = new DisplayNameSetImpl();

	/** The expiration cache. */
	private String expirationCache = null;

	/** The id. */
	public String id = "";

	/** The init params. */
	private ParameterSet initParams = new ParameterSetImpl();

	/** The init security role refs. */
	private SecurityRoleRefSet initSecurityRoleRefs = new SecurityRoleRefSetImpl();

	/** The name. */
	private String name = null;

	/** The object id. */
	private ObjectID objectId = null;

	/** The preferences. */
	private PreferenceSet preferences = new PreferenceSetImpl();

	//    private PortletInfoImpl portletInfo = null;
	/** The resource bundle. */
	private String resourceBundle = null;

	/** The servlet. */
	private ServletDefinition servlet = null;

	// contains Locale objects
	/** The supported locales. */
	private final ArrayList<Locale> supportedLocales = new ArrayList<Locale>();

	// PortletDefinition implementation.
	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Override
	public ObjectID getId() {
		if (objectId == null) {
			objectId = ObjectIDImpl.createFromString(getGUID());
		}
		return objectId;
	}

	/**
	 * Gets the class name.
	 *
	 * @return the class name
	 */
	@Override
	public String getClassName() {
		return className;
	}

	/**
	 * Gets the name.
	 *
	 * @return the name
	 */
	@Override
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.portlet.PortletDefinition#getDescription(Locale)
	 */
	/**
	 * Gets the description.
	 *
	 * @param locale
	 *            the locale
	 *
	 * @return the description
	 */
	@Override
	public Description getDescription(final Locale locale) {
		return descriptions.get(locale);
	}

	/**
	 * Gets the language set.
	 *
	 * @return the language set
	 */
	@Override
	public LanguageSet getLanguageSet() {
		((LanguageSetImpl) castorResources).setClassLoader(this.getPortletClassLoader());
		return castorResources;
	}

	/**
	 * Gets the inits the parameter set.
	 *
	 * @return the inits the parameter set
	 */
	@Override
	public ParameterSet getInitParameterSet() {
		return initParams;
	}

	/**
	 * Gets the inits the security role ref set.
	 *
	 * @return the inits the security role ref set
	 */
	@Override
	public SecurityRoleRefSet getInitSecurityRoleRefSet() {
		return initSecurityRoleRefs;
	}

	/**
	 * Gets the preference set.
	 *
	 * @return the preference set
	 */
	@Override
	public PreferenceSet getPreferenceSet() {
		((PreferenceSetImpl) preferences).setClassLoader(this.getPortletClassLoader());
		return preferences;
	}

	/**
	 * Gets the content type set.
	 *
	 * @return the content type set
	 */
	@Override
	public ContentTypeSet getContentTypeSet() {
		return contentTypes;
	}

	/**
	 * Gets the portlet application definition.
	 *
	 * @return the portlet application definition
	 */
	@Override
	public PortletApplicationDefinition getPortletApplicationDefinition() {
		return application;
	}

	/**
	 * Gets the servlet definition.
	 *
	 * @return the servlet definition
	 */
	@Override
	public ServletDefinition getServletDefinition() {
		return servlet;
	}

	/**
	 * Gets the display name.
	 *
	 * @param locale
	 *            the locale
	 *
	 * @return the display name
	 */
	@Override
	public DisplayName getDisplayName(final Locale locale) {
		return displayNames.get(locale);
	}

	/**
	 * Gets the expiration cache.
	 *
	 * @return the expiration cache
	 */
	@Override
	public String getExpirationCache() {
		return expirationCache;
	}

	// PortletDefinitionCtrl implementation.
	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	@Override
	public void setId(final String id) {
		// todo excep
	}

	/**
	 * Sets the class name.
	 *
	 * @param className
	 *            the new class name
	 */
	@Override
	public void setClassName(final String className) {
		this.className = className;
	}

	/**
	 * Sets the name.
	 *
	 * @param name
	 *            the new name
	 */
	@Override
	public void setName(final String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.portlet.PortletDefinitionCtrl#setDescriptions(DescriptionSet)
	 */
	/**
	 * Sets the descriptions.
	 *
	 * @param descriptions
	 *            the new descriptions
	 */
	@Override
	public void setDescriptions(final DescriptionSet descriptions) {
		this.descriptions = descriptions;
	}

	/**
	 * Sets the display names.
	 *
	 * @param displayNames
	 *            the new display names
	 */
	@Override
	public void setDisplayNames(final DisplayNameSet displayNames) {
		this.displayNames = displayNames;
	}

	/**
	 * Sets the portlet class loader.
	 *
	 * @param loader
	 *            the new portlet class loader
	 */
	@Override
	public void setPortletClassLoader(final ClassLoader loader) {
		this.classLoader = loader;
	}

	/**
	 * Store.
	 *
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	public void store() throws java.io.IOException {
		// not supported
	}

	// org.apache.pluto.portalImpl.om.common.Support implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postBuild(java.lang.Object)
	 */
	@Override
	public void postBuild(final Object parameter) throws Exception {
		setServletDefinition((ServletDefinition) parameter);
		((Support) contentTypes).postBuild(this);
		if (castorResources != null) {
			((Support) castorResources).postBuild(this);
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postLoad(java.lang.Object)
	 */
	@Override
	public void postLoad(final Object parameter) throws Exception {
		((Support) contentTypes).postLoad(this);
		// create Locale objects for given locale entries
		final Iterator<String> iterator = castorSupportedLocales.iterator();
		while (iterator.hasNext()) {
			final String locale = iterator.next();
			// parse locale String
			final StringTokenizer tokenizer = new StringTokenizer(locale, "_");
			final String[] localeDef = new String[3];
			for (int i = 0; i < 3; i++) {
				if (tokenizer.hasMoreTokens()) {
					localeDef[i] = tokenizer.nextToken();
				} else {
					localeDef[i] = "";
				}
			}
			supportedLocales.add(new java.util.Locale(localeDef[0], localeDef[1], localeDef[2]));
		}
		if (castorResources == null) {
			castorResources = new LanguageSetImpl();
		}
		if (resourceBundle != null) {
			((LanguageSetImpl) castorResources).setResources(resourceBundle);
		}
		((Support) castorResources).postLoad(this.supportedLocales);
		((Support) descriptions).postLoad(parameter);
		((Support) displayNames).postLoad(parameter);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postStore(java.lang.Object)
	 */
	@Override
	public void postStore(final Object parameter) throws Exception {
		((Support) contentTypes).postStore(this);
		if (castorResources != null) {
			((Support) castorResources).postStore(this);
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preBuild(java.lang.Object)
	 */
	@Override
	public void preBuild(final Object parameter) throws Exception {
		setPortletApplicationDefinition((PortletApplicationDefinition) parameter);
		((Support) contentTypes).preBuild(this);
		if (castorResources != null) {
			((Support) castorResources).preBuild(this);
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preStore(java.lang.Object)
	 */
	@Override
	public void preStore(final Object parameter) throws Exception {
		((Support) contentTypes).preStore(this);
		if (castorResources != null) {
			((Support) castorResources).preStore(this);
		}
	}

	// additional methods.
	/**
	 * Gets the castor content types.
	 *
	 * @return the castor content types
	 */
	public Collection<?> getCastorContentTypes() {
		return (ContentTypeSetImpl) contentTypes;
	}

	/**
	 * Gets the castor display names.
	 *
	 * @return the castor display names
	 */
	public Collection<?> getCastorDisplayNames() {
		return (DisplayNameSetImpl) displayNames;
	}

	/**
	 * Gets the castor descriptions.
	 *
	 * @return the castor descriptions
	 */
	public Collection<?> getCastorDescriptions() {
		return (DescriptionSetImpl) descriptions;
	}

	/**
	 * Gets the descriptions.
	 *
	 * @return the descriptions
	 */
	public Collection<?> getDescriptions() {
		return (DescriptionSetImpl) descriptions;
	}

	/**
	 * Gets the castor init params.
	 *
	 * @return the castor init params
	 */
	public Collection<?> getCastorInitParams() {
		return (ParameterSetImpl) initParams;
	}

	/**
	 * Gets the castor init security role refs.
	 *
	 * @return the castor init security role refs
	 */
	public SecurityRoleRefSet getCastorInitSecurityRoleRefs() {
		return initSecurityRoleRefs;
	}

	/**
	 * Gets the castor preferences.
	 *
	 * @return the castor preferences
	 */
	public PreferenceSet getCastorPreferences() {
		return preferences;
	}

	/**
	 * Gets the castor resources.
	 *
	 * @return the castor resources
	 */
	public LanguageSet getCastorResources() {
		return castorResources;
	}

	// not yet fully supported
	// public Collection getSecurityRoleRef()
	// {
	//     return securityRoleRef;
	// }
	// public void setSecurityRoleRef(Collection securityRoleRef)
	// {
	//     this.securityRoleRef = (ArrayList)securityRoleRef;
	// }
	// additional internal methods
	/**
	 * Gets the castor supported locales.
	 *
	 * @return the castor supported locales
	 */
	public Collection<String> getCastorSupportedLocales() {
		return castorSupportedLocales;
	}

	/**
	 * Gets the gUID.
	 *
	 * @return the gUID
	 */
	private String getGUID() {
		String portletID = "";
		if (getName() != null) {
			portletID += getName();
		}
		portletID = application.getId().toString() + "." + portletID;
		return portletID;
	}

	/**
	 * Gets the portlet class loader.
	 *
	 * @return the portlet class loader
	 */
	@Override
	public ClassLoader getPortletClassLoader() {
		return classLoader;
	}

	/**
	 * Gets the resource bundle.
	 *
	 * @return the resource bundle
	 */
	public String getResourceBundle() {
		return this.resourceBundle;
	}

	/**
	 * Gets the supported locales.
	 *
	 * @return the supported locales
	 */
	public Collection<Locale> getSupportedLocales() {
		return supportedLocales;
	}

	/**
	 * Sets the castor content types.
	 *
	 * @param castorContentTypes
	 *            the new castor content types
	 */
	public void setCastorContentTypes(final ContentTypeSet castorContentTypes) {
		this.contentTypes = castorContentTypes;
	}

	/**
	 * Sets the castor init params.
	 *
	 * @param castorInitParams
	 *            the new castor init params
	 */
	public void setCastorInitParams(final ParameterSet castorInitParams) {
		this.initParams = castorInitParams;
	}

	/**
	 * Sets the castor init security role refs.
	 *
	 * @param castorInitSecurityRoleRefs
	 *            the new castor init security role refs
	 */
	public void setCastorInitSecurityRoleRefs(final SecurityRoleRefSet castorInitSecurityRoleRefs) {
		this.initSecurityRoleRefs = castorInitSecurityRoleRefs;
	}

	/**
	 * Sets the castor display names.
	 *
	 * @param castorDisplayNames
	 *            the new castor display names
	 */
	public void setCastorDisplayNames(final DisplayNameSet castorDisplayNames) {
		this.displayNames = castorDisplayNames;
	}

	/**
	 * Sets the castor descriptions.
	 *
	 * @param castorDescriptions
	 *            the new castor descriptions
	 */
	public void setCastorDescriptions(final DescriptionSet castorDescriptions) {
		this.descriptions = castorDescriptions;
	}

	/**
	 * Sets the castor preferences.
	 *
	 * @param castorPreferences
	 *            the new castor preferences
	 */
	public void setCastorPreferences(final PreferenceSet castorPreferences) {
		this.preferences = castorPreferences;
	}

	/**
	 * Sets the castor resources.
	 *
	 * @param resources
	 *            the new castor resources
	 */
	public void setCastorResources(final LanguageSet resources) {
		this.castorResources = resources;
	}

	/**
	 * Sets the castor supported locales.
	 *
	 * @param castorSupportedLocales
	 *            the new castor supported locales
	 */
	public void setCastorSupportedLocales(final Collection<String> castorSupportedLocales) {
		this.castorSupportedLocales = (ArrayList<String>) castorSupportedLocales;
	}

	/**
	 * Sets the expiration cache.
	 *
	 * @param expirationCache
	 *            the new expiration cache
	 */
	public void setExpirationCache(final String expirationCache) {
		this.expirationCache = expirationCache;
	}

	/**
	 * Sets the portlet application definition.
	 *
	 * @param application
	 *            the new portlet application definition
	 */
	protected void setPortletApplicationDefinition(final PortletApplicationDefinition application) {
		this.application = application;
	}

	/**
	 * Sets the resource bundle.
	 *
	 * @param resourceBundle
	 *            the new resource bundle
	 */
	public void setResourceBundle(final String resourceBundle) {
		this.resourceBundle = resourceBundle;
	}

	/**
	 * Sets the servlet definition.
	 *
	 * @param servlet
	 *            the new servlet definition
	 */
	protected void setServletDefinition(final ServletDefinition servlet) {
		this.servlet = servlet;
	}

	// internal methods used for debugging purposes only
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(":");
		StringUtils.newLine(buffer, indent);
		buffer.append("{");
		StringUtils.newLine(buffer, indent);
		buffer.append("objectID='");
		buffer.append(getId());
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("guid='");
		buffer.append(getGUID());
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("id='");
		buffer.append(id);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("name='");
		buffer.append(name);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append(((LanguageSetImpl) castorResources).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((ParameterSetImpl) initParams).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((PreferenceSetImpl) preferences).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((SecurityRoleRefSetImpl) initSecurityRoleRefs).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((ContentTypeSetImpl) contentTypes).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((DescriptionSetImpl) descriptions).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((DisplayNameSetImpl) displayNames).toString(indent));
		if (servlet != null) {
			StringUtils.newLine(buffer, indent);
			buffer.append("servlet:");
			buffer.append(((ServletDefinitionImpl) servlet).toString(indent + 2));
		}
		StringUtils.newLine(buffer, indent);
		buffer.append("}");
		return buffer.toString();
	}
}
