/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.definition.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionList;
import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.portalImpl.om.common.AbstractSupportSet;
import org.apache.pluto.portalImpl.om.common.Support;
import org.apache.pluto.util.StringUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletDefinitionListImpl.
 */
public class PortletDefinitionListImpl extends AbstractSupportSet implements PortletDefinitionList, java.io.Serializable, Support {

	/**
	 *
	 */
	private static final long serialVersionUID = -1463451616008748065L;

	// PortletDefinitionList implementation.
	/**
	 * Gets the.
	 *
	 * @param objectId
	 *            the object id
	 *
	 * @return the portlet definition
	 */
	@Override
	public PortletDefinition get(final ObjectID objectId) {
		@SuppressWarnings("unchecked")
		final Iterator<PortletDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletDefinition portletDefinition = iterator.next();
			if (portletDefinition.getId().equals(objectId)) {
				return portletDefinition;
			}
		}
		return null;
	}

	// Support implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preBuild(Object)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public void preBuild(final Object parameter) throws Exception {
		final Vector<Object> structure = (Vector<Object>) parameter;
		final PortletApplicationDefinition portletApplication = (PortletApplicationDefinition) structure.get(0);
		final Map<String, ServletDefinition> servletMap = (Map<String, ServletDefinition>) structure.get(1);
		final Iterator<PortletDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletDefinition portlet = iterator.next();
			((Support) portlet).preBuild(portletApplication);
			ServletDefinition servlet = null;
			if (servletMap != null) {
				servlet = servletMap.get(portlet.getId().toString());
			}
			((Support) portlet).postBuild(servlet);
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postBuild(Object)
	 */
	@Override
	public void postBuild(final Object parameter) throws Exception {}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postLoad(Object)
	 */
	@Override
	public void postLoad(final Object parameter) throws Exception {
		@SuppressWarnings("unchecked")
		final Iterator<PortletDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			((PortletDefinitionImpl) iterator.next()).postLoad(parameter);
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postStore(Object)
	 */
	@Override
	public void postStore(final Object parameter) throws Exception {}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preStore(Object)
	 */
	@Override
	public void preStore(final Object parameter) throws Exception {}

	// additional methods.
	/**
	 * Gets the.
	 *
	 * @param objectId
	 *            the object id
	 *
	 * @return the portlet definition
	 */
	public PortletDefinition get(final String objectId) {
		@SuppressWarnings("unchecked")
		final Iterator<PortletDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletDefinition portletDefinition = iterator.next();
			if (portletDefinition.getId().toString().equals(objectId)) {
				return portletDefinition;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see java.util.AbstractCollection#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(": ");
		@SuppressWarnings("unchecked")
		final Iterator<PortletDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			buffer.append(((PortletDefinitionImpl) iterator.next()).toString(indent + 2));
		}
		return buffer.toString();
	}
}
