/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.entity.impl;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletEntityList;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.portalImpl.services.ConfigurationException;
import org.apache.pluto.util.StringUtils;

import com.univ.portail.service.registry.PortletDefinitionRegistry;
import com.univ.portail.util.ObjectIDImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletApplicationEntityImpl.
 */
public class PortletApplicationEntityImpl implements PortletApplicationEntity, java.io.Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 1133999109839560632L;

	/** The id. */
	private String id = "";

	/** The definition id. */
	private String definitionId = "";

	/** The portlets. */
	private PortletEntityList portlets = new PortletEntityListImpl();

	/** The object id. */
	private ObjectID objectId = null;

	// PortletApplicationEntity implementation.
	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Override
	public ObjectID getId() {
		if (objectId == null) {
			objectId = ObjectIDImpl.createFromString(id);
		}
		return objectId;
	}

	/**
	 * Gets the portlet entity list.
	 *
	 * @return the portlet entity list
	 */
	@Override
	public PortletEntityList getPortletEntityList() {
		return portlets;
	}

	/**
	 * Gets the portlet application definition.
	 *
	 * @return the portlet application definition
	 */
	@Override
	public PortletApplicationDefinition getPortletApplicationDefinition() {
		final PortletApplicationDefinition definition = PortletDefinitionRegistry.getPortletApplicationDefinitionList().get(ObjectIDImpl.createFromString(definitionId));
		if (definition == null) {
			throw new ConfigurationException(
				"Unable to find portlet application definition. " + "Ensure that all portlets definied within the portlet registry are correct" + "and have been deployed.");
		}
		return definition;
	}

	// additional methods.
	// additional internal methods
	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	public void setId(final String id) {
		this.id = id;
		objectId = null;
	}

	/**
	 * Gets the definition id.
	 *
	 * @return the definition id
	 */
	public String getDefinitionId() {
		return definitionId;
	}

	/**
	 * Sets the definition id.
	 *
	 * @param definitionId
	 *            the new definition id
	 */
	public void setDefinitionId(final String definitionId) {
		this.definitionId = definitionId;
	}

	/**
	 * Sets the portlet entity list.
	 *
	 * @param portletEntityList
	 *            the new portlet entity list
	 */
	public void setPortletEntityList(final PortletEntityList portletEntityList) {
		if (this.portlets == null || !portletEntityList.equals(this.portlets)) {
			this.portlets = portletEntityList;
		}
	}

	// internal methods used for debugging purposes only
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(1000);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(":");
		StringUtils.newLine(buffer, indent);
		buffer.append("{");
		StringUtils.newLine(buffer, indent);
		buffer.append("id='");
		buffer.append(id);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("definition-id='");
		buffer.append(definitionId);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append(((PortletEntityListImpl) portlets).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append("}");
		return buffer.toString();
	}
}
