/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.entity.impl;

import java.util.HashSet;
import java.util.Iterator;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.entity.PortletApplicationEntityListCtrl;
import org.apache.pluto.util.StringUtils;

import com.univ.portail.util.ObjectIDImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletApplicationEntityListImpl.
 */
public class PortletApplicationEntityListImpl extends HashSet<PortletApplicationEntity>
	implements PortletApplicationEntityList, PortletApplicationEntityListCtrl, java.io.Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 7477689640843777053L;

	// PortletApplicationEntityList implementation.
	/**
	 * Gets the.
	 *
	 * @param objectId
	 *            the object id
	 *
	 * @return the portlet application entity
	 */
	@Override
	public PortletApplicationEntity get(final ObjectID objectId) {
		final Iterator<PortletApplicationEntity> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletApplicationEntity portletApplicationEntity = iterator.next();
			if (portletApplicationEntity.getId().equals(objectId)) {
				return portletApplicationEntity;
			}
		}
		return null;
	}

	// PortletApplicationEntityListCtrl implementation.
	/**
	 * Ajoute à la liste des applications l'application identifiée par la chaine passée en paramètre.
	 *
	 * @param definitionId
	 *            identifiant de l'application
	 *
	 * @return the portlet application entity
	 */
	@Override
	public PortletApplicationEntity add(final String definitionId) {
		PortletApplicationEntity applicationEntity = null;
		applicationEntity = get(ObjectIDImpl.createFromString(definitionId));
		if (applicationEntity == null) {
			applicationEntity = new PortletApplicationEntityImpl();
			((PortletApplicationEntityImpl) applicationEntity).setId(definitionId);
			String ajout = definitionId;
			if (definitionId.contains(".")) {
				ajout = definitionId.substring(0, definitionId.indexOf("."));
			}
			((PortletApplicationEntityImpl) applicationEntity).setDefinitionId(ajout);
			add(applicationEntity);
		}
		return applicationEntity;
	}

	/**
	 * Gets the.
	 *
	 * @param objectId
	 *            the object id
	 *
	 * @return the portlet application entity
	 */
	public PortletApplicationEntity get(final String objectId) {
		final Iterator<PortletApplicationEntity> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletApplicationEntity portletApplicationEntity = iterator.next();
			if (portletApplicationEntity.getId().toString().equals(objectId)) {
				return portletApplicationEntity;
			}
		}
		return null;
	}

	// internal methods used for debugging purposes only
	/* (non-Javadoc)
	 * @see java.util.AbstractCollection#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(1000);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(":");
		StringUtils.newLine(buffer, indent);
		buffer.append("{");
		final Iterator<PortletApplicationEntity> iterator = this.iterator();
		if (iterator.hasNext()) {
			StringUtils.newLine(buffer, indent);
			buffer.append("Portlet Application Entities:");
		}
		while (iterator.hasNext()) {
			buffer.append(((PortletApplicationEntityImpl) iterator.next()).toString(indent + 2));
		}
		StringUtils.newLine(buffer, indent);
		buffer.append("}");
		return buffer.toString();
	}
}
