/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.entity.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.DescriptionSet;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityCtrl;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.portalImpl.om.common.impl.DescriptionSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.PreferenceSetImpl;
import org.apache.pluto.portalImpl.om.window.impl.PortletWindowListImpl;
import org.apache.pluto.portalImpl.services.ConfigurationException;
import org.apache.pluto.util.StringUtils;
import org.slf4j.LoggerFactory;

import com.univ.portail.util.ObjectIDImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletEntityImpl.
 */
public class PortletEntityImpl implements PortletEntity, PortletEntityCtrl, java.io.Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -7751261491265761604L;

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(PortletEntityImpl.class);

	/** The id. */
	private String id;

	/** The definition id. */
	private String definitionId;

	/** The preferences. */
	protected PreferenceSet preferences;

	/** The orig preferences. */
	private PreferenceSet origPreferences;

	/** The application entity. */
	private PortletApplicationEntity applicationEntity;

	/** The portlet windows. */
	private PortletWindowList portletWindows;

	/** The object id. */
	private ObjectID objectId;

	/** The descriptions. */
	private final DescriptionSet descriptions;

	/**
	 * Instantiates a new portlet entity impl.
	 */
	public PortletEntityImpl() {
		id = "";
		definitionId = "";
		preferences = new PreferenceSetImpl();
		origPreferences = new PreferenceSetImpl();
		portletWindows = new PortletWindowListImpl();
		descriptions = new DescriptionSetImpl();
	}

	// PortletEntity implementation.
	/**
	 * Gets the id.
	 *
	 * @return the id
	 *
	 * @see PortletEntity#getId()
	 */
	@Override
	public ObjectID getId() {
		if (objectId == null && applicationEntity != null) {
			//objectId = ObjectIDImpl.createFromString(definitionId);
			objectId = ObjectIDImpl.createFromString(id);
		}
		return objectId;
	}

	/**
	 * Gets the preference set.
	 *
	 * @return the preference set
	 */
	@Override
	public PreferenceSet getPreferenceSet() {
		return preferences;
	}

	/**
	 * Gets the portlet definition.
	 *
	 * @return the portlet definition
	 */
	@Override
	public PortletDefinition getPortletDefinition() {
		final PortletDefinition def = applicationEntity.getPortletApplicationDefinition().getPortletDefinitionList().get(ObjectIDImpl.createFromString(definitionId));
		//      PortletDefinition def = applicationEntity.getPortletApplicationDefinition().getPortletDefinitionList().get(
		//      ObjectIDImpl.createFromString(id));
		if (def == null) {
			throw new ConfigurationException(
				"Unable to obtain portlet definition for :" + definitionId + " Perhaps a portlet has been defined incorrectly in the portlet registry.");
		}
		return def;
	}

	/**
	 * Sets the portlet definition.
	 *
	 * @param portletDefinition
	 *            the new portlet definition
	 */
	@Override
	public void setPortletDefinition(final PortletDefinition portletDefinition) {
		this.definitionId = portletDefinition.getId().toString();
	}

	/**
	 * Gets the portlet application entity.
	 *
	 * @return the portlet application entity
	 */
	@Override
	public PortletApplicationEntity getPortletApplicationEntity() {
		return applicationEntity;
	}

	/**
	 * Gets the portlet window list.
	 *
	 * @return the portlet window list
	 */
	@Override
	public PortletWindowList getPortletWindowList() {
		return portletWindows;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.apache.pluto.om.entity.PortletEntity#getDescriptionSet()
	 */
	/**
	 * Gets the description.
	 *
	 * @param locale
	 *            the locale
	 *
	 * @return the description
	 */
	@Override
	public Description getDescription(final Locale locale) {
		return descriptions.get(locale);
	}

	// PortletEntityCtrl implementation.
	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	@Override
	public void setId(final String id) {
		this.id = id;
		objectId = null;
	}

	/**
	 * Store.
	 *
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	public void store() throws java.io.IOException {
		LOG.debug("on enregistre les préférences normalement...");
		@SuppressWarnings("unchecked")
		final Iterator<Preference> itPref = preferences.iterator();
		while (itPref.hasNext()) {
			final Preference pref = itPref.next();
			LOG.debug(pref.toString());
			final Preference origPref = origPreferences.get(pref.getName());
			if (origPref != null) {
				LOG.debug("comp: " + origPref.toString());
			}
		}
		// TODO
		// PortletEntityRegistry.store();
		//
		// //save preferences as original preferences
		// origPreferences = new PreferenceSetImpl();
		// ((PreferenceSetImpl)origPreferences).addAll((Collection)preferences);
	}

	/**
	 * Reset.
	 *
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	public void reset() throws java.io.IOException {
		// reset by re-activating original preferences
		preferences = new PreferenceSetImpl();
		((PreferenceSetImpl) preferences).clear();
		((PreferenceSetImpl) preferences).addAll((Collection<?>) origPreferences);
	}

	// org.apache.pluto.portalImpl.om.common.Support implementation.
	/**
	 * Sets the portlet application entity.
	 *
	 * @param applicationEntity
	 *            the new portlet application entity
	 */
	public void setPortletApplicationEntity(final PortletApplicationEntity applicationEntity) {
		this.applicationEntity = applicationEntity;
	}

	/**
	 * Sets the portlet window list.
	 *
	 * @param portletWindows
	 *            the new portlet window list
	 */
	public void setPortletWindowList(final PortletWindowList portletWindows) {
		this.portletWindows = portletWindows;
	}

	//    public String getDefinitionId() {
	//        return definitionId;
	//    }
	/**
	 * Sets the definition id.
	 *
	 * @param definitionId
	 *            the new definition id
	 */
	public void setDefinitionId(final String definitionId) {
		this.definitionId = definitionId;
	}

	// internal methods used for debugging purposes only
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(1000);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(":");
		StringUtils.newLine(buffer, indent);
		buffer.append("{");
		StringUtils.newLine(buffer, indent);
		buffer.append("id='");
		buffer.append(id);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("definition-id='");
		buffer.append(definitionId);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append(((PreferenceSetImpl) preferences).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((DescriptionSetImpl) descriptions).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append("}");
		return buffer.toString();
	}

	/**
	 * Sets the orig preferences.
	 *
	 * @param origPreferences
	 *            the new orig preferences
	 */
	public void setOrigPreferences(final PreferenceSet origPreferences) {
		this.origPreferences = origPreferences;
	}
}
