/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.entity.impl;

import java.util.HashSet;
import java.util.Iterator;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityList;
import org.apache.pluto.om.entity.PortletEntityListCtrl;
import org.apache.pluto.util.StringUtils;

import com.univ.portail.util.ObjectIDImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletEntityListImpl.
 */
public class PortletEntityListImpl extends HashSet<PortletEntity> implements PortletEntityList, PortletEntityListCtrl, java.io.Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 3014399647778849123L;

	// PortletEntityList implementation.
	/**
	 * Gets the.
	 *
	 * @param objectId
	 *            the object id
	 *
	 * @return the portlet entity
	 */
	@Override
	public PortletEntity get(final ObjectID objectId) {
		final Iterator<PortletEntity> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletEntity portletEntity = iterator.next();
			if (portletEntity.getId().equals(objectId)) {
				return portletEntity;
			}
		}
		return null;
	}

	// PortletEntityListCtrl implementation.
	/**
	 * Adds the.
	 *
	 * @param appEntity
	 *            the app entity
	 * @param definitionId
	 *            the definition id
	 *
	 * @return the portlet entity
	 */
	@Override
	public PortletEntity add(final PortletApplicationEntity appEntity, final String definitionId) {
		PortletEntity entity = null;
		entity = get(ObjectIDImpl.createFromString(definitionId));
		if (entity == null) {
			entity = new PortletEntityImpl();
			((PortletEntityImpl) entity).setId(definitionId);
			//((PortletEntityImpl) entity).setDefinitionId(definitionId);
			((PortletEntityImpl) entity).setDefinitionId(appEntity.getId().toString());
			((PortletEntityImpl) entity).setPortletApplicationEntity(appEntity);
			add(entity);
		}
		return entity;
	}

	// additional methods.
	/**
	 * Retourne le portlet entity correspondant à l'id passé.
	 *
	 * @param objectId
	 *            identifiant correspondant à la représentation <code>ObjetID.toString()</code>
	 *
	 * @return the portlet entity
	 */
	public PortletEntity get(final String objectId) {
		final Iterator<PortletEntity> iterator = this.iterator();
		while (iterator.hasNext()) {
			final PortletEntity portletEntity = iterator.next();
			if (portletEntity.getId().equals(objectId)) {
				return portletEntity;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see java.util.AbstractCollection#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(": ");
		final Iterator<PortletEntity> iterator = this.iterator();
		while (iterator.hasNext()) {
			buffer.append(((PortletEntityImpl) iterator.next()).toString(indent + 2));
		}
		return buffer.toString();
	}
}
