/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.servlet.impl;

import java.util.Collection;
import java.util.Locale;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;

import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.DescriptionSet;
import org.apache.pluto.om.common.DisplayName;
import org.apache.pluto.om.common.DisplayNameSet;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.ParameterSet;
import org.apache.pluto.om.common.SecurityRoleRefSet;
import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.om.servlet.ServletDefinitionCtrl;
import org.apache.pluto.om.servlet.WebApplicationDefinition;
import org.apache.pluto.portalImpl.om.common.Support;
import org.apache.pluto.portalImpl.om.common.impl.DescriptionSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.DisplayNameSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.ParameterSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.SecurityRoleRefSetImpl;
import org.apache.pluto.portalImpl.om.servlet.impl.ServletMappingImpl;
import org.apache.pluto.util.StringUtils;
import org.slf4j.LoggerFactory;

import com.univ.portail.util.ObjectIDImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class ServletDefinitionImpl.
 */
public class ServletDefinitionImpl implements ServletDefinition, ServletDefinitionCtrl, java.io.Serializable, Support {

	/**
	 *
	 */
	private static final long serialVersionUID = 5011271238240697377L;

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(ServletDefinitionImpl.class);

	/** The descriptions. */
	private DescriptionSet descriptions = new DescriptionSetImpl();

	/** The display names. */
	private DisplayNameSet displayNames = new DisplayNameSetImpl();

	// not used variables - only for castor
	/** The icon. */
	public String icon = null;

	/** The id. */
	private String id = "";

	/** The init params. */
	private final ParameterSet initParams = new ParameterSetImpl();

	/** The init security role refs. */
	private SecurityRoleRefSet initSecurityRoleRefs = new SecurityRoleRefSetImpl();

	/** The jsp file. */
	public String jspFile = null;

	/** The load on startup. */
	public String loadOnStartup = null;

	/** The object id. */
	private ObjectID objectId = null;

	/** The security role ref. */
	public String securityRoleRef = null;

	/** The servlet class. */
	private String servletClass = null;

	/** The servlet mapping. */
	private ServletMappingImpl servletMapping = null;

	/** The servlet name. */
	private String servletName = null;

	/** The available. */
	private long available = 0;

	/** The web application. */
	private WebApplicationDefinition webApplication = null;

	// ServletDefinition implementation.
	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Override
	public ObjectID getId() {
		if (objectId == null) {
			objectId = ObjectIDImpl.createFromString(id);
		}
		return objectId;
	}

	/**
	 * Gets the servlet name.
	 *
	 * @return the servlet name
	 */
	@Override
	public String getServletName() {
		return servletName;
	}

	/**
	 * Gets the display name.
	 *
	 * @param locale
	 *            the locale
	 *
	 * @return the display name
	 */
	@Override
	public DisplayName getDisplayName(final Locale locale) {
		return displayNames.get(locale);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.servlet.ServletDefinition#getDescription(Locale)
	 */
	/**
	 * Gets the description.
	 *
	 * @param locale
	 *            the locale
	 *
	 * @return the description
	 */
	@Override
	public Description getDescription(final Locale locale) {
		return descriptions.get(locale);
	}

	/**
	 * Gets the servlet class.
	 *
	 * @return the servlet class
	 */
	@Override
	public String getServletClass() {
		return servletClass;
	}

	/**
	 * Gets the inits the parameter set.
	 *
	 * @return the inits the parameter set
	 */
	@Override
	public ParameterSet getInitParameterSet() {
		return initParams;
	}

	/**
	 * Gets the web application definition.
	 *
	 * @return the web application definition
	 */
	@Override
	public WebApplicationDefinition getWebApplicationDefinition() {
		return webApplication;
	}

	/**
	 * Gets the request dispatcher.
	 *
	 * @param servletContext
	 *            the servlet context
	 *
	 * @return the request dispatcher
	 */
	@Override
	public RequestDispatcher getRequestDispatcher(final ServletContext servletContext) {
		final ServletContext newContext = webApplication.getServletContext(servletContext);
		if (newContext == null) {
			LOG.error("ServletContext '" + ((WebApplicationDefinitionImpl) webApplication).getContextRoot() + "' not found!");
			return null;
		}
		if (LOG.isDebugEnabled()) {
			LOG.debug("Looking up RequestDispatcher for servlet mapping " + servletMapping.getUrlPattern());
		}
		return newContext.getRequestDispatcher(servletMapping.getUrlPattern());
	}

	/**
	 * Gets the available.
	 *
	 * @return the available
	 */
	@Override
	public long getAvailable() {
		return available;
	}

	/**
	 * Checks if is unavailable.
	 *
	 * @return true, if is unavailable
	 */
	@Override
	public boolean isUnavailable() {
		if (available == 0) {
			return false;
		} else if (available <= System.currentTimeMillis()) {
			available = 0;
			return false;
		} else {
			return true;
		}
	}

	// Support implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postBuild(java.lang.Object)
	 */
	@Override
	public void postBuild(final Object parameter) throws Exception {
		setServletMapping((ServletMappingImpl) parameter);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postLoad(java.lang.Object)
	 */
	@Override
	public void postLoad(final Object parameter) throws Exception {
		((Support) descriptions).postLoad(parameter);
		((Support) displayNames).postLoad(parameter);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postStore(java.lang.Object)
	 */
	@Override
	public void postStore(final Object parameter) throws Exception {}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preBuild(java.lang.Object)
	 */
	@Override
	public void preBuild(final Object parameter) throws Exception {
		setWebApplicationDefinition((WebApplicationDefinition) parameter);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preStore(java.lang.Object)
	 */
	@Override
	public void preStore(final Object parameter) throws Exception {}

	// additional methods.
	/**
	 * Gets the castor id.
	 *
	 * @return the castor id
	 */
	public String getCastorId() {
		if (id.length() > 0) {
			return getId().toString();
		} else {
			return null;
		}
	}

	/**
	 * Gets the castor init params.
	 *
	 * @return the castor init params
	 */
	public Collection getCastorInitParams() {
		return (ParameterSetImpl) initParams;
	}

	/**
	 * Gets the castor init security role refs.
	 *
	 * @return the castor init security role refs
	 */
	public SecurityRoleRefSet getCastorInitSecurityRoleRefs() {
		return initSecurityRoleRefs;
	}

	/**
	 * Gets the castor display names.
	 *
	 * @return the castor display names
	 */
	public Collection getCastorDisplayNames() {
		return (DisplayNameSetImpl) displayNames;
	}

	/**
	 * Gets the castor descriptions.
	 *
	 * @return the castor descriptions
	 */
	public Collection getCastorDescriptions() {
		return (DescriptionSetImpl) descriptions;
	}

	/**
	 * Gets the descriptions.
	 *
	 * @return the descriptions
	 */
	public Collection getDescriptions() {
		return (DescriptionSetImpl) descriptions;
	}

	/**
	 * Gets the inits the security role ref set.
	 *
	 * @return the inits the security role ref set
	 */
	public SecurityRoleRefSet getInitSecurityRoleRefSet() {
		return initSecurityRoleRefs;
	}

	/**
	 * Gets the jsp file.
	 *
	 * @return the jsp file
	 */
	public String getJspFile() {
		return jspFile;
	}

	/**
	 * Sets the castor id.
	 *
	 * @param id
	 *            the new castor id
	 */
	public void setCastorId(final String id) {
		setId(id);
	}

	/**
	 * Sets the castor init security role refs.
	 *
	 * @param castorInitSecurityRoleRefs
	 *            the new castor init security role refs
	 */
	public void setCastorInitSecurityRoleRefs(final SecurityRoleRefSet castorInitSecurityRoleRefs) {
		this.initSecurityRoleRefs = castorInitSecurityRoleRefs;
	}

	/**
	 * Sets the castor display names.
	 *
	 * @param castorDisplayNames
	 *            the new castor display names
	 */
	public void setCastorDisplayNames(final DisplayNameSet castorDisplayNames) {
		this.displayNames = castorDisplayNames;
	}

	/**
	 * Sets the castor descriptions.
	 *
	 * @param castorDescriptions
	 *            the new castor descriptions
	 */
	public void setCastorDescriptions(final DescriptionSet castorDescriptions) {
		this.descriptions = castorDescriptions;
	}

	/**
	 * Sets the display names.
	 *
	 * @param displayNames
	 *            the new display names
	 */
	@Override
	public void setDisplayNames(final DisplayNameSet displayNames) {
		this.displayNames = displayNames;
	}

	/**
	 * Sets the descriptions.
	 *
	 * @param descriptions
	 *            the new descriptions
	 */
	@Override
	public void setDescriptions(final DescriptionSet descriptions) {
		this.descriptions = descriptions;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	@Override
	public void setId(final String id) {
		this.id = id;
		objectId = null;
	}

	/**
	 * Sets the servlet class.
	 *
	 * @param servletClass
	 *            the new servlet class
	 */
	@Override
	public void setServletClass(final String servletClass) {
		this.servletClass = servletClass;
	}

	/**
	 * Sets the available.
	 *
	 * @param available
	 *            the new available
	 */
	@Override
	public void setAvailable(final long available) {
		if (available > System.currentTimeMillis()) {
			this.available = available;
		} else {
			this.available = 0;
		}
	}

	/**
	 * Sets the jsp file.
	 *
	 * @param jspFile
	 *            the new jsp file
	 */
	public void setJspFile(final String jspFile) {
		this.jspFile = jspFile;
	}

	/**
	 * Sets the servlet mapping.
	 *
	 * @param servletMapping
	 *            the new servlet mapping
	 */
	protected void setServletMapping(final ServletMappingImpl servletMapping) {
		this.servletMapping = servletMapping;
	}

	/**
	 * Sets the servlet name.
	 *
	 * @param servletName
	 *            the new servlet name
	 */
	@Override
	public void setServletName(final String servletName) {
		this.servletName = servletName;
	}

	/**
	 * Sets the web application definition.
	 *
	 * @param webApplication
	 *            the new web application definition
	 */
	protected void setWebApplicationDefinition(final WebApplicationDefinition webApplication) {
		this.webApplication = webApplication;
	}

	// internal methods used for debugging purposes only
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(":");
		StringUtils.newLine(buffer, indent);
		buffer.append("{");
		StringUtils.newLine(buffer, indent);
		buffer.append("id='");
		buffer.append(id);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("servletName='");
		buffer.append(servletName);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append(((DescriptionSetImpl) descriptions).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((DisplayNameSetImpl) displayNames).toString(indent));
		if (servletClass != null) {
			buffer.append("servletClass='");
			buffer.append(servletClass);
			buffer.append("'");
		} else if (jspFile != null) {
			buffer.append("jspFile='");
			buffer.append(jspFile);
			buffer.append("'");
		}
		StringUtils.newLine(buffer, indent);
		buffer.append(((ParameterSetImpl) initParams).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((SecurityRoleRefSetImpl) initSecurityRoleRefs).toString(indent));
		if (servletMapping != null) {
			StringUtils.newLine(buffer, indent);
			buffer.append("Linked ServletMapping:");
			buffer.append(servletMapping.toString(indent + 2));
		}
		StringUtils.newLine(buffer, indent);
		buffer.append("}");
		return buffer.toString();
	}
}
