/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.servlet.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.om.servlet.ServletDefinitionList;
import org.apache.pluto.om.servlet.ServletDefinitionListCtrl;
import org.apache.pluto.om.servlet.WebApplicationDefinition;
import org.apache.pluto.portalImpl.om.common.AbstractSupportSet;
import org.apache.pluto.portalImpl.om.common.Support;
import org.apache.pluto.portalImpl.om.servlet.impl.ServletMappingImpl;
import org.apache.pluto.util.StringUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class ServletDefinitionListImpl.
 */
public class ServletDefinitionListImpl extends AbstractSupportSet implements ServletDefinitionList, ServletDefinitionListCtrl, java.io.Serializable, Support {

	/**
	 *
	 */
	private static final long serialVersionUID = 557334956955359113L;

	// ServletDefinitionList implementation.
	/**
	 * Gets the.
	 *
	 * @param name
	 *            the name
	 *
	 * @return the servlet definition
	 */
	@Override
	public ServletDefinition get(final String name) {
		@SuppressWarnings("unchecked")
		final Iterator<ServletDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			final ServletDefinition servletDefinition = iterator.next();
			if (servletDefinition.getServletName().equals(name)) {
				return servletDefinition;
			}
		}
		return null;
	}

	// ServletDefinitionListCtrl implementation.
	/**
	 * Adds the.
	 *
	 * @param name
	 *            the name
	 * @param className
	 *            the class name
	 *
	 * @return the servlet definition
	 */
	@Override
	@SuppressWarnings("unchecked")
	public ServletDefinition add(final String name, final String className) {
		final ServletDefinitionImpl servletDefinition = new ServletDefinitionImpl();
		servletDefinition.setServletName(name);
		servletDefinition.setServletClass(className);
		super.add(servletDefinition);
		return servletDefinition;
	}

	/**
	 * Removes the.
	 *
	 * @param name
	 *            the name
	 *
	 * @return the servlet definition
	 */
	@Override
	public ServletDefinition remove(final String name) {
		@SuppressWarnings("unchecked")
		final Iterator<ServletDefinition> iterator = this.iterator();
		while (iterator.hasNext()) {
			final ServletDefinition servletDefinition = iterator.next();
			if (servletDefinition.getServletName().equals(name)) {
				super.remove(servletDefinition);
				return servletDefinition;
			}
		}
		return null;
	}

	/**
	 * Removes the.
	 *
	 * @param servletDefinition
	 *            the servlet definition
	 */
	@Override
	public void remove(final ServletDefinition servletDefinition) {
		super.remove(servletDefinition);
	}

	// Support implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.AbstractSupportSet#preBuild(java.lang.Object)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public void preBuild(final Object parameter) throws Exception {
		final Vector<Object> structure = (Vector<Object>) parameter;
		final WebApplicationDefinition webApplicationDefinition = (WebApplicationDefinition) structure.get(0);
		final Collection<ServletMappingImpl> servletMappings = (Collection<ServletMappingImpl>) structure.get(1);
		final HashMap<String, ServletDefinition> servletMap = (HashMap<String, ServletDefinition>) structure.get(2);
		// build internal hashtable to cross link mappings with servlets
		final HashMap<String, ServletMappingImpl> mappings = new HashMap<String, ServletMappingImpl>(servletMappings.size());
		Iterator<ServletMappingImpl> iterator = servletMappings.iterator();
		while (iterator.hasNext()) {
			final ServletMappingImpl servletMapping = iterator.next();
			mappings.put(servletMapping.getServletName(), servletMapping);
		}
		// update servlets
		iterator = this.iterator();
		while (iterator.hasNext()) {
			final ServletDefinition servlet = (ServletDefinition) iterator.next();
			((Support) servlet).preBuild(webApplicationDefinition);
			if (servlet.getInitParameterSet() != null) {
				if (servlet.getInitParameterSet().get("portlet-guid") != null) {
					final String guid = servlet.getInitParameterSet().get("portlet-guid").getValue();
					servletMap.put(guid, servlet);
					final ServletMappingImpl servletMapping = mappings.get(servlet.getServletName());
					((Support) servlet).postBuild(servletMapping);
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postBuild(Object)
	 */
	@Override
	public void postBuild(final Object parameter) throws Exception {}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postLoad(Object)
	 */
	@Override
	public void postLoad(final Object parameter) throws Exception {
		@SuppressWarnings("unchecked")
		final Iterator<ServletDefinitionImpl> iterator = this.iterator();
		while (iterator.hasNext()) {
			iterator.next().postLoad(parameter);
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postStore(Object)
	 */
	@Override
	public void postStore(final Object parameter) throws Exception {}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preStore(Object)
	 */
	@Override
	public void preStore(final Object parameter) throws Exception {}

	// additional methods.
	/* (non-Javadoc)
	 * @see java.util.AbstractCollection#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(": ");
		@SuppressWarnings("unchecked")
		final Iterator<ServletDefinitionImpl> iterator = this.iterator();
		while (iterator.hasNext()) {
			buffer.append(iterator.next().toString(indent + 2));
		}
		return buffer.toString();
	}
}
