/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.om.servlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

import javax.servlet.ServletContext;

import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.DescriptionSet;
import org.apache.pluto.om.common.DisplayName;
import org.apache.pluto.om.common.DisplayNameSet;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.ParameterSet;
import org.apache.pluto.om.common.SecurityRoleSet;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.servlet.ServletDefinitionList;
import org.apache.pluto.om.servlet.WebApplicationDefinition;
import org.apache.pluto.portalImpl.om.common.Support;
import org.apache.pluto.portalImpl.om.common.impl.DescriptionSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.DisplayNameSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.ParameterSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.SecurityRoleSetImpl;
import org.apache.pluto.portalImpl.om.servlet.impl.ResourceRefSet;
import org.apache.pluto.portalImpl.om.servlet.impl.ServletMappingImpl;
import org.apache.pluto.portalImpl.om.servlet.impl.TagDefinitionSet;
import org.apache.pluto.util.StringUtils;
import org.slf4j.LoggerFactory;

import com.univ.portail.util.ObjectIDImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class WebApplicationDefinitionImpl.
 */
public class WebApplicationDefinitionImpl implements WebApplicationDefinition, java.io.Serializable, Support {

	/**
	 *
	 */
	private static final long serialVersionUID = 9161795362557010601L;

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(WebApplicationDefinitionImpl.class);

	// <not used variables - only for castor>
	/** The icon. */
	public String icon = null;

	/** The distributable. */
	public String distributable = null;

	/** The session config. */
	public String sessionConfig = null;

	/** The mime mapping. */
	public String mimeMapping = null;

	/** The welcome file list. */
	public String welcomeFileList = null;

	/** The error page. */
	public String errorPage = null;

	/** The taglib. */
	public String taglib = null;

	/** The resource ref. */
	public String resourceRef = null;

	/** The login config. */
	public String loginConfig = null;

	/** The security role. */
	public String securityRole = null;

	/** The env entry. */
	public String envEntry = null;

	/** The ejb ref. */
	public String ejbRef = null;

	/** The castor mime mappings. */
	private Collection castorMimeMappings = new ArrayList<>(); // </not used variables - only for castor>

	/** The security constraints. */
	private Collection securityConstraints = new ArrayList<>();

	/** The context path. */
	private String contextPath = null;

	/** The descriptions. */
	private DescriptionSet descriptions = new DescriptionSetImpl();

	/** The display names. */
	private DisplayNameSet displayNames = new DisplayNameSetImpl();

	/** The id. */
	private String id = "";

	/** The init params. */
	private final ParameterSet initParams = new ParameterSetImpl();

	/** The object id. */
	private ObjectID objectId = null;

	/** The servlet mappings. */
	private final Collection servletMappings = new ArrayList<>();

	/** The servlets. */
	private final ServletDefinitionList servlets = new ServletDefinitionListImpl();

	/** The security roles. */
	private final SecurityRoleSet securityRoles = new SecurityRoleSetImpl();

	// modified by YCLI: START :: to handle multiple taglib tags and resource-ref tag
	// private TagDefinition castorTagDefinition = new TagDefinition();
	/** The taglibs. */
	private TagDefinitionSet taglibs = new TagDefinitionSet();

	/** The castor resource ref. */
	private ResourceRefSet castorResourceRef = new ResourceRefSet();

	// modified by YCLI: END
	// WebApplicationDefinition implementation.
	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Override
	public ObjectID getId() {
		if (objectId == null) {
			objectId = ObjectIDImpl.createFromString(id);
		}
		return objectId;
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.servlet.WebApplicationDefinition#getDisplayName(Locale)
	 */
	/**
	 * Gets the display name.
	 *
	 * @param locale
	 *            the locale
	 *
	 * @return the display name
	 */
	@Override
	public DisplayName getDisplayName(final Locale locale) {
		return displayNames.get(locale);
	}

	/**
	 * Gets the description.
	 *
	 * @param locale
	 *            the locale
	 *
	 * @return the description
	 */
	@Override
	public Description getDescription(final Locale locale) {
		return descriptions.get(locale);
	}

	/**
	 * Gets the inits the parameter set.
	 *
	 * @return the inits the parameter set
	 */
	@Override
	public ParameterSet getInitParameterSet() {
		return initParams;
	}

	/**
	 * Gets the servlet definition list.
	 *
	 * @return the servlet definition list
	 */
	@Override
	public ServletDefinitionList getServletDefinitionList() {
		return servlets;
	}

	/**
	 * Gets the servlet context.
	 *
	 * @param servletContext
	 *            the servlet context
	 *
	 * @return the servlet context
	 */
	@Override
	public ServletContext getServletContext(final ServletContext servletContext) {
		if (LOG.isDebugEnabled()) {
			LOG.debug("Looking up ServletContext for path " + contextPath);
		}
		return servletContext.getContext(contextPath);
	}

	/**
	 * Gets the context root.
	 *
	 * @return the context root
	 */
	@Override
	public String getContextRoot() {
		return contextPath;
	}

	// Support implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postBuild(java.lang.Object)
	 */
	@Override
	public void postBuild(final Object parameter) throws Exception {
		// not needed in this implementation
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postLoad(java.lang.Object)
	 */
	@Override
	public void postLoad(final Object parameter) throws Exception {
		final Vector<PortletApplicationDefinition> structure = (Vector<PortletApplicationDefinition>) parameter;
		final PortletApplicationDefinition portletApplication = structure.get(0);
		//String contextString = (String)structure.get(1);
		((Support) portletApplication).postLoad(this);
		((Support) servlets).postLoad(this);
		((Support) descriptions).postLoad(parameter);
		((Support) displayNames).postLoad(parameter);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#postStore(java.lang.Object)
	 */
	@Override
	public void postStore(final Object parameter) throws Exception {
		((Support) servlets).postStore(this);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preBuild(java.lang.Object)
	 */
	@Override
	public void preBuild(final Object parameter) throws Exception {
		final Vector<Object> structure = (Vector<Object>) parameter;
		final PortletApplicationDefinition portletApplication = (PortletApplicationDefinition) structure.get(0);
		final String contextString = (String) structure.get(1);
		setContextRoot(contextString);
		final HashMap servletMap = new HashMap<>(1);
		final Vector<Object> structure2 = new Vector<Object>();
		structure2.add(this);
		structure2.add(servletMappings);
		structure2.add(servletMap);
		((Support) servlets).preBuild(structure2);
		final Vector<Serializable> structure3 = new Vector<Serializable>();
		structure3.add(contextString);
		structure3.add(this);
		structure3.add(servletMap);
		((Support) portletApplication).preBuild(structure3);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.portalImpl.om.common.Support#preStore(java.lang.Object)
	 */
	@Override
	public void preStore(final Object parameter) throws Exception {
		final Vector<PortletApplicationDefinition> structure = (Vector<PortletApplicationDefinition>) parameter;
		final PortletApplicationDefinition portletApplication = structure.get(0);
		//String contextString = (String)structure.get(1);
		((Support) portletApplication).preStore(null);
		((Support) servlets).preStore(this);
	}

	// additional methods.
	/**
	 * Gets the castor id.
	 *
	 * @return the castor id
	 */
	public String getCastorId() {
		if (id.length() > 0) {
			return getId().toString();
		} else {
			return null;
		}
	}

	/**
	 * Gets the castor init params.
	 *
	 * @return the castor init params
	 */
	public Collection getCastorInitParams() {
		return (ParameterSetImpl) initParams;
	}

	/**
	 * Gets the castor servlets.
	 *
	 * @return the castor servlets
	 */
	public Collection getCastorServlets() {
		return (ServletDefinitionListImpl) servlets;
	}

	/**
	 * Gets the castor display names.
	 *
	 * @return the castor display names
	 */
	public Collection getCastorDisplayNames() {
		return (DisplayNameSetImpl) displayNames;
	}

	/**
	 * Gets the castor descriptions.
	 *
	 * @return the castor descriptions
	 */
	public Collection getCastorDescriptions() {
		return (DescriptionSetImpl) descriptions;
	}

	/**
	 * Gets the security roles.
	 *
	 * @return the security roles
	 */
	@Override
	public SecurityRoleSet getSecurityRoles() {
		return securityRoles;
	}

	/**
	 * Gets the servlet mappings.
	 *
	 * @return the servlet mappings
	 */
	public Collection getServletMappings() {
		return servletMappings;
	}

	/**
	 * Sets the castor id.
	 *
	 * @param id
	 *            the new castor id
	 */
	public void setCastorId(final String id) {
		setId(id);
	}

	/**
	 * Sets the context root.
	 *
	 * @param contextPath
	 *            the new context root
	 */
	protected void setContextRoot(String contextPath) {
		// Test for IBM WebSphere
		if (contextPath != null && contextPath.endsWith(".war")) {
			contextPath = contextPath.substring(0, contextPath.length() - 4);
		}
		this.contextPath = contextPath;
	}

	/**
	 * Sets the descriptions.
	 *
	 * @param descriptions
	 *            the new descriptions
	 */
	public void setDescriptions(final DescriptionSet descriptions) {
		this.descriptions = descriptions;
	}

	/**
	 * Sets the display names.
	 *
	 * @param displayNames
	 *            the new display names
	 */
	public void setDisplayNames(final DisplayNameSet displayNames) {
		this.displayNames = displayNames;
	}

	/**
	 * Sets the castor descriptions.
	 *
	 * @param castorDescriptions
	 *            the new castor descriptions
	 */
	public void setCastorDescriptions(final DescriptionSet castorDescriptions) {
		this.descriptions = castorDescriptions;
	}

	/**
	 * Sets the castor display names.
	 *
	 * @param castorDisplayNames
	 *            the new castor display names
	 */
	public void setCastorDisplayNames(final DisplayNameSet castorDisplayNames) {
		this.displayNames = castorDisplayNames;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	public void setId(final String id) {
		this.id = id;
		objectId = null;
	}

	// internal methods used for debugging purposes only
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(":");
		StringUtils.newLine(buffer, indent);
		buffer.append("{");
		StringUtils.newLine(buffer, indent);
		buffer.append("id='");
		buffer.append(id);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append(((DisplayNameSetImpl) displayNames).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((DescriptionSetImpl) descriptions).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((ParameterSetImpl) initParams).toString(indent));
		StringUtils.newLine(buffer, indent);
		buffer.append(((ServletDefinitionListImpl) servlets).toString(indent));
		final Iterator<?> iterator = servletMappings.iterator();
		if (iterator.hasNext()) {
			StringUtils.newLine(buffer, indent);
			buffer.append("ServletMappings:");
		}
		while (iterator.hasNext()) {
			buffer.append(((ServletMappingImpl) iterator.next()).toString(indent + 2));
		}
		StringUtils.newLine(buffer, indent);
		buffer.append("contextPath='");
		buffer.append(contextPath);
		buffer.append("'");
		StringUtils.newLine(buffer, indent);
		buffer.append("}");
		return buffer.toString();
	}

	// modified by YCLI: START :: handling multiple taglib tags and resource-ref tag
	/**
	 * Gets the tag definition set.
	 *
	 * @return Custom tag definitions configured in the webapp.
	 */
	public TagDefinitionSet getTagDefinitionSet() {
		return taglibs;
	}

	/**
	 * Gets the castor tag definitions.
	 *
	 * @return the castor tag definitions
	 */
	public Collection getCastorTagDefinitions() {
		return taglibs;
	}

	/**
	 * Sets the castor tag definitions.
	 *
	 * @param taglibs
	 *            the new castor tag definitions
	 */
	public void setCastorTagDefinitions(final TagDefinitionSet taglibs) {
		this.taglibs = taglibs;
	}

	/**
	 * Gets the castor resource ref set.
	 *
	 * @return the castor resource ref set
	 */
	public ResourceRefSet getCastorResourceRefSet() {
		return castorResourceRef;
	}

	/**
	 * Sets the castor resource ref set.
	 *
	 * @param resourceRefs
	 *            the new castor resource ref set
	 */
	public void setCastorResourceRefSet(final ResourceRefSet resourceRefs) {
		castorResourceRef = resourceRefs;
	}

	// modified by YCLI: END
	/**
	 * Gets the castor mime mappings.
	 *
	 * @return Returns the castorMimeMappings.
	 */
	public Collection getCastorMimeMappings() {
		return castorMimeMappings;
	}

	/**
	 * Gets the security constraints.
	 *
	 * @return the security constraints
	 */
	public Collection getSecurityConstraints() {
		return securityConstraints;
	}

	/**
	 * Sets the castor mime mappings.
	 *
	 * @param castorMimeMappings
	 *            The castorMimeMappings to set.
	 */
	public void setCastorMimeMappings(final Collection castorMimeMappings) {
		this.castorMimeMappings = castorMimeMappings;
	}

	/**
	 * Sets the security constraints.
	 *
	 * @param securityConstraints
	 *            the new security constraints
	 */
	public void setSecurityConstraints(final Collection securityConstraints) {
		this.securityConstraints = securityConstraints;
	}
}
