/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.om.user;

import java.util.List;

import org.apache.pluto.om.common.PreferenceSet;

import com.univ.objetspartages.om.InfosPreferences;

// TODO: Auto-generated Javadoc
/**
 * Interface représentant les préférences utilisateur.
 * 
 * @author EBO
 */
public interface UserPreference {

	/**
	 * Méthode permettant d'enregistrer les préférences.
	 * 
	 * @param prefSet
	 *            the pref set
	 * @param service
	 *            the service
	 */
	public void store(PreferenceSet prefSet, String service);

	/**
	 * Méthode permettant de retourner la liste des préférences de l'utilisateur.
	 * 
	 * @param service
	 *            the service
	 * 
	 * @return liste de préférences liée à l'utilisateur pour un service donné
	 */
	public List<InfosPreferences> getUserPreferencesFromService(String service);
}
