/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.om.window.impl;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.om.window.PortletWindowCtrl;

import com.univ.portail.util.ObjectIDImpl;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletWindowImpl.
 */
public class PortletWindowImpl implements PortletWindow, PortletWindowCtrl {

	/** The object id. */
	private ObjectID objectId;

	/** The id. */
	private String id;

	/** The portlet entity. */
	private PortletEntity portletEntity;

	/**
	 * Instantiates a new portlet window impl.
	 * 
	 * @param id
	 *            the id
	 */
	public PortletWindowImpl(String id) {
		this.id = id;
	}

	// PortletWindow implementation.
	/**
	 * Returns the identifier of this portlet instance window as object id.
	 * 
	 * @return the object identifier
	 */
	@Override
	public ObjectID getId() {
		if (objectId == null) {
			objectId = ObjectIDImpl.createFromString(id);
		}
		return objectId;
	}

	/**
	 * Returns the portlet entity.
	 * 
	 * @return the portlet entity
	 */
	@Override
	public PortletEntity getPortletEntity() {
		return portletEntity;
	}

	// PortletWindowCtrl implementation.
	/**
	 * binds an identifier to this portlet window.
	 * 
	 * @param id
	 *            the new identifier
	 */
	@Override
	public void setId(String id) {
		this.id = id;
		objectId = null;
	}

	/**
	 * binds a portlet instance to this portlet window.
	 * 
	 * @param portletEntity
	 *            a portlet entity object
	 */
	@Override
	public void setPortletEntity(PortletEntity portletEntity) {
		this.portletEntity = portletEntity;
	}
}