/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.service.config;

import org.apache.pluto.portalImpl.util.Parameters;

import com.univ.portail.service.ServiceManager;

// TODO: Auto-generated Javadoc
/**
 * * The static accessor for the {@link ConfigService}. * * @see ConfigService
 */
public class Config {

	/** The config. */
	private static ConfigService config = (ConfigService) ServiceManager.getService(ConfigService.class);

	/**
	 * Instantiates a new config.
	 */
	private Config() {
		config = new ConfigServiceImpl();
	}

	/**
	 * * @see ConfigService#getParameters.
	 * 
	 * @return the parameters
	 */
	public static Parameters getParameters() {
		return config.getParameters();
	}

	/**
	 * Gets the service.
	 * 
	 * @return the service
	 */
	public static ConfigService getService() {
		return config;
	}
}
