/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.service.config;

import java.util.Iterator;

import org.apache.pluto.portalImpl.util.Parameters;

import com.univ.portail.service.ServiceInit;

// TODO: Auto-generated Javadoc
/**
 * * The <CODE>ConfigService</CODE> holds the basic portal * configuration. * * @see Config
 */
public abstract class ConfigService extends ServiceInit {

	/**
	 * * Returns the configuration parameters managed by this service. * * @return the configuration parameters
	 * 
	 * @return the parameters
	 */
	public abstract Parameters getParameters();

	/**
	 * Gets the string.
	 * 
	 * @param name
	 *            the name
	 * 
	 * @return the string
	 */
	public String getString(final String name) {
		return getParameters().getString(name);
	}

	/**
	 * Gets the string.
	 * 
	 * @param name
	 *            the name
	 * @param defaultValue
	 *            the default value
	 * 
	 * @return the string
	 */
	public String getString(final String name, final String defaultValue) {
		return getParameters().getString(name, defaultValue);
	}

	/**
	 * Gets the integer.
	 * 
	 * @param name
	 *            the name
	 * 
	 * @return the integer
	 */
	public Integer getInteger(final String name) {
		return getParameters().getInteger(name);
	}

	/**
	 * Gets the integer.
	 * 
	 * @param name
	 *            the name
	 * @param defaultValue
	 *            the default value
	 * 
	 * @return the integer
	 */
	public Integer getInteger(final String name, final Integer defaultValue) {
		return getParameters().getInteger(name, defaultValue);
	}

	/**
	 * Gets the integer.
	 * 
	 * @param name
	 *            the name
	 * @param defaultValue
	 *            the default value
	 * 
	 * @return the integer
	 */
	public int getInteger(final String name, final int defaultValue) {
		return getParameters().getInteger(name, defaultValue);
	}

	/**
	 * Gets the boolean.
	 * 
	 * @param name
	 *            the name
	 * 
	 * @return the boolean
	 */
	public Boolean getBoolean(final String name) {
		return getParameters().getBoolean(name);
	}

	/**
	 * Gets the boolean.
	 * 
	 * @param name
	 *            the name
	 * @param defaultValue
	 *            the default value
	 * 
	 * @return the boolean
	 */
	public Boolean getBoolean(final String name, final Boolean defaultValue) {
		return getParameters().getBoolean(name, defaultValue);
	}

	/**
	 * Gets the boolean.
	 * 
	 * @param name
	 *            the name
	 * @param defaultValue
	 *            the default value
	 * 
	 * @return the boolean
	 */
	public boolean getBoolean(final String name, final boolean defaultValue) {
		return getParameters().getBoolean(name, defaultValue);
	}

	/**
	 * Keys.
	 * 
	 * @return the java.util. iterator
	 */
	public Iterator keys() {
		return getParameters().keys();
	}
}
