/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.service.config;

import javax.servlet.ServletConfig;

import org.apache.pluto.portalImpl.util.Parameters;

import com.univ.portail.util.Properties;

// TODO: Auto-generated Javadoc
/**
 * * The implementation of the {@link ConfigService}. * *
 * <P>
 * * To establish the configuration parameters, this implementation * first looks in the servlet configuration, then the servlet * context, and lastly its own configuration file.
 */
public class ConfigServiceImpl extends ConfigService {

	/* (non-Javadoc)
	 * @see com.univ.portail.service.ServiceInit#init(javax.servlet.ServletConfig, com.univ.portail.util.Properties)
	 */
	@Override
	public void init(ServletConfig aConfig, Properties aProperties) throws Exception {
		iParameters = new Parameters(aConfig);
		Parameters contextParams = new Parameters(aConfig.getServletContext());
		contextParams.setParent(aProperties);
		iParameters.setParent(contextParams);
	}

	/* (non-Javadoc)
	 * @see com.univ.portail.service.ServiceInit#destroy()
	 */
	@Override
	public void destroy() {
		iParameters = null;
	}

	/* (non-Javadoc)
	 * @see com.univ.portail.service.config.ConfigService#getParameters()
	 */
	@Override
	public Parameters getParameters() {
		return (iParameters);
	}

	/** The i parameters. */
	private Parameters iParameters;
}
