/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.service.factorymanager;

import org.apache.pluto.factory.Factory;

import com.univ.portail.service.ServiceManager;

// TODO: Auto-generated Javadoc
/**
 * Manages the life-time of factories registered during container startup. A service has to derive from {@link Factory} and implement the <CODE>init()</CODE> and
 * <CODE>destroy()</CODE> methods as appropriate.
 * 
 * @see Factory
 */
public class FactoryManager {

	/**
	 * * Returns the service implementation for the given service class, or * <CODE>null</CODE> if no such service is registered. * * @param theClass * the service class * * @return
	 * the service implementation
	 * 
	 * @param theClass
	 *            the the class
	 * 
	 * @return the factory
	 */
	public static Factory getFactory(final Class<?> theClass) {
		return cService.getFactory(theClass);
	}

	/**
	 * Gets the service.
	 * 
	 * @return the service
	 */
	public static FactoryManagerService getService() {
		return cService;
	}

	/** The Constant cService. */
	private final static FactoryManagerService cService = (FactoryManagerService) ServiceManager.getService(FactoryManagerService.class);
}
