/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.service.registry;

import javax.servlet.ServletContext;

import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinitionList;
import org.apache.pluto.om.portlet.PortletDefinition;

import com.univ.objetspartages.om.Service;
import com.univ.portail.service.ServiceManager;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletDefinitionRegistry.
 */
public class PortletDefinitionRegistry {

	/** The instance. */
	private static ServiceChargementPorltetsDefinition instance = (ServiceChargementPorltetsDefinition) ServiceManager.getService(ServiceChargementPorltetsDefinition.class);

	/**
	 * Returns a set containg all portlet application definitions.
	 * 
	 * @return the portlet application definition set
	 */
	public static PortletApplicationDefinitionList getPortletApplicationDefinitionList() {
		return instance.getApplicationDefinitionList();
	}

	/**
	 * Returns the portlet definition to the given object id.
	 * 
	 * @param id
	 *            the id
	 * 
	 * @return the portlet definition
	 */
	public static PortletDefinition getPortletDefinition(ObjectID id) {
		return instance.getDefinitionList().get(id);
	}

	/**
	 * Ajouter definition.
	 * 
	 * @param servletContext
	 *            the servlet context
	 * @param service
	 *            the service
	 */
	public static void ajouterDefinition(ServletContext servletContext, Service service) {
		if (instance != null) {
			instance.chargerPortletDefinition(service.getPortletDefinitionId(), servletContext);
		}
	}

	/**
	 * Forcer relecture.
	 */
	public static void forcerRelecture() {
		if (instance != null) {
			instance.forcerRelectureApplication();
		}
	}
}
