/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.service.registry;

import java.util.List;

import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityList;

import com.univ.objetspartages.om.InfosPreferences;
import com.univ.objetspartages.om.Service;
import com.univ.portail.service.ServiceManager;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletEntityRegistry.
 */
public class PortletEntityRegistry {

	/** The instance. */
	private static ServiceChargementPortletsEntity instance = (ServiceChargementPortletsEntity) ServiceManager.getService(ServiceChargementPortletsEntity.class);

	/**
	 * Gets the portlet entity.
	 * 
	 * @param id
	 *            the id
	 * 
	 * @return the portlet entity
	 */
	public static PortletEntity getPortletEntity(final String id) {
		return instance.getPortletEntity(id);
	}

	/**
	 * Gets the portlet application entity list.
	 * 
	 * @return the portlet application entity list
	 */
	public static PortletApplicationEntityList getPortletApplicationEntityList() {
		return instance.getApplicationEntityList();
	}

	/**
	 * Gets the portlet entity list.
	 * 
	 * @return the portlet entity list
	 */
	public static PortletEntityList getPortletEntityList() {
		return instance.getListeEntity();
	}

	/**
	 * Ajouter entity.
	 * 
	 * @param service
	 *            the service
	 * @param listePreferences
	 *            the liste preferences
	 */
	public static void ajouterEntity(final Service service, final List<InfosPreferences> listePreferences) {
		//TODO test !null instance
		if (instance != null) {
			instance.ajouterServiceEntity(service.getCode(), service.getPortletDefinitionId(), listePreferences);
		}
	}

	/**
	 * Forcer relecture.
	 */
	public static void forcerRelecture() {
		if (instance != null) {
			instance.forcerRelectureEntity();
		}
	}
}
