/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.service.registry;

import javax.portlet.PortletException;

import com.univ.portail.KportalPortletFragment;
import com.univ.portail.service.ServiceManager;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletOccurenceRegistry.
 */
public class PortletOccurenceRegistry {

	/** The instance. */
	private static ServiceOccurence instance = (ServiceOccurence) ServiceManager.getService(ServiceOccurence.class);

	/**
	 * Gets the occurence.
	 * 
	 * @param id
	 *            the id
	 * 
	 * @return the occurence
	 */
	public static KportalPortletFragment getOccurence(String id) {
		return instance.getOccurence(id);
	}

	/**
	 * Ajouter fragment.
	 * 
	 * @param codePortlet
	 *            the code portlet
	 * @param ctx
	 *            the ctx
	 * 
	 * @return the kportal portlet fragment
	 * 
	 * @throws PortletException
	 *             the portlet exception
	 */
	public static KportalPortletFragment ajouterFragment(String codePortlet) throws PortletException {
		if (instance != null) {
			return instance.ajouterFragment(codePortlet);
		} else {
			return null;
		}
	}

	/**
	 * Force le rechargement de toutes les applications.
	 * 
	 * @throws Exception
	 */
	public static void forcerRelecture() {
		if (instance != null) {
			instance.forcerRechargementFragments();
		}
	}
}
