/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.service.registry;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletConfig;

import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityList;
import org.apache.pluto.portalImpl.om.common.impl.PreferenceSetImpl;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.univ.objetspartages.om.InfosPreferences;
import com.univ.portail.om.entity.impl.PortletApplicationEntityImpl;
import com.univ.portail.om.entity.impl.PortletApplicationEntityListImpl;
import com.univ.portail.om.entity.impl.PortletEntityImpl;
import com.univ.portail.om.entity.impl.PortletEntityListImpl;
import com.univ.portail.service.ServiceInit;
import com.univ.portail.util.Properties;

// TODO: Auto-generated Javadoc
/**
 * The Class ServiceChargementPortletsEntity.
 */
public class ServiceChargementPortletsEntity extends ServiceInit {

	/** Table des portletentity, pour un accès plus rapide. */
	private final Map<String, PortletEntity> tablePortletEntity = new Hashtable<String, PortletEntity>();

	/** Liste des applications entity. */
	protected PortletApplicationEntityList listeApplicationEntity = null;

	/** liste des entity. */
	protected PortletEntityList listeEntity = null;

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(ServiceChargementPortletsEntity.class);

	/**
	 * Instantiates a new service chargement portlets entity.
	 */
	public ServiceChargementPortletsEntity() {
		if (listeApplicationEntity == null) {
			listeApplicationEntity = new PortletApplicationEntityListImpl();
		}
		if (listeEntity == null) {
			listeEntity = new PortletEntityListImpl();
		}
	}

	/* (non-Javadoc)
	 * @see com.univ.portail.service.ServiceInit#init(javax.servlet.ServletConfig, com.univ.portail.util.Properties)
	 */
	@Override
	protected void init(final ServletConfig config, final Properties aProperties) throws Exception {
		final ContextePage ctx = new ContextePage("");
		try {
			init(ctx);
		} catch (final Exception ex) {
			LOG.error("Exception lors de l'initialisation des applications Portlets", ex);
			throw ex;
		} finally {
			ctx.release();
		}
	}

	/**
	 * Inits the.
	 * 
	 * @param ctx
	 *            the ctx
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void init(final OMContext ctx) throws Exception {
		//chargerServicesFromBase(ctx);
	}

	/**
	 * Ajouter service entity.
	 * 
	 * @param codePortlet
	 *            the code portlet
	 * @param portletDefinitionId
	 *            the portlet definition id
	 * @param listePreferences
	 *            the liste preferences
	 */
	public synchronized void ajouterServiceEntity(final String codePortlet, final String portletDefinitionId, final List<InfosPreferences> listePreferences) {
		//String codeApplication = portletDefinitionId.substring(0,portletDefinitionId.indexOf("."));
		//String codeApplication = codePortlet;
		//on ajoute l'application
		final PortletApplicationEntity applicationEntity = ((PortletApplicationEntityListImpl) listeApplicationEntity).add(portletDefinitionId);
		//Ajout de l'entité portlet.
		final PortletEntity entity = ((PortletEntityListImpl) listeEntity).add(applicationEntity, codePortlet);
		//PortletEntity entity = ((PortletEntityListImpl)listeEntity).add(applicationEntity, portletDefinitionId);
		//on ajoute les préférences générales
		if (listePreferences != null) {
			final PreferenceSetImpl prefSet = new PreferenceSetImpl();
			InfosPreferences infosPref = null;
			for (final Object element : listePreferences) {
				infosPref = (InfosPreferences) element;
				prefSet.add(infosPref.getNom(), infosPref.getValeursAsList());
			}
			((PortletEntityImpl) entity).setOrigPreferences(prefSet);
			try {
				//on tente d'initialiser les préférences
				((PortletEntityImpl) entity).reset();
			} catch (final IOException ex) {
				//l'initialisation n'a pas fonctionné, on continue quand même.
				final String message = "L'initialisation des préférences générales de la portlet: '" + portletDefinitionId + "' ne s'est pas bien déroulée. L'application continue de fonctionner malgré l'exception.";
				LOG.error(message, ex);
			}
		}
		//      on ajoute la portlet entity dans la liste des entity
		tablePortletEntity.put(codePortlet, entity);
		//on lie les entity à l'application.
		((PortletApplicationEntityImpl) applicationEntity).setPortletEntityList(listeEntity);
	}

	/**
	 * Gets the portlet entity.
	 * 
	 * @param id
	 *            the id
	 * 
	 * @return the portlet entity
	 */
	public PortletEntity getPortletEntity(final String id) {
		if (tablePortletEntity.containsKey(id)) {
			return tablePortletEntity.get(id);
		} else {
			//            throw new PortletException("La portlet demandée: '" + id + "' n'existe pas.");
			return null;
		}
	}

	/**
	 * Gets the application entity list.
	 * 
	 * @return the application entity list
	 */
	public PortletApplicationEntityList getApplicationEntityList() {
		return listeApplicationEntity;
	}

	/**
	 * Gets the liste entity.
	 * 
	 * @return the liste entity
	 */
	public PortletEntityList getListeEntity() {
		return listeEntity;
	}

	/**
	 * Force le rechargement de toutes les applications.
	 * 
	 * @throws Exception
	 */
	public void forcerRelectureEntity() {
		listeApplicationEntity = new PortletApplicationEntityListImpl();
		listeEntity = new PortletEntityListImpl();
	}
}
