/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.portail.service.registry;

import java.util.Hashtable;
import java.util.Map;

import javax.portlet.PortletException;
import javax.servlet.ServletConfig;

import com.univ.portail.KportalPortletFragment;
import com.univ.portail.service.ServiceInit;
import com.univ.portail.util.Properties;

// TODO: Auto-generated Javadoc
/**
 * The Class ServiceOccurence.
 */
public class ServiceOccurence extends ServiceInit {

	/** The table occurences. */
	private Map<String, KportalPortletFragment> tableOccurences = null;

	/* (non-Javadoc)
	 * @see com.univ.portail.service.ServiceInit#init(javax.servlet.ServletConfig, com.univ.portail.util.Properties)
	 */
	@Override
	protected void init(final ServletConfig aConfig, final Properties aProperties) throws Exception {
		if (tableOccurences == null) {
			tableOccurences = new Hashtable<String, KportalPortletFragment>();
		}
	}

	/**
	 * Gets the occurence.
	 * 
	 * @param id
	 *            the id
	 * 
	 * @return the occurence
	 */
	public KportalPortletFragment getOccurence(final String id) {
		return tableOccurences.get(id);
	}

	/**
	 * Ajouter fragment.
	 * 
	 * @param nomOccurence
	 *            the nom occurence
	 * @param ctx
	 *            the ctx
	 * 
	 * @return the kportal portlet fragment
	 * 
	 * @throws PortletException
	 *             the portlet exception
	 */
	public KportalPortletFragment ajouterFragment(final String nomOccurence) throws PortletException {
		if (!tableOccurences.containsKey(nomOccurence)) {
			final KportalPortletFragment kpf = new KportalPortletFragment(nomOccurence);
			tableOccurences.put(nomOccurence, kpf);
			return kpf;
		} else {
			return getOccurence(nomOccurence);
		}
	}

	/**
	 * Force le rechargement de toutes les applications.
	 * 
	 * @throws Exception
	 */
	public void forcerRechargementFragments() {
		tableOccurences = new Hashtable<String, KportalPortletFragment>();
	}
}
