/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.servlet;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.servlet.ServletRequestFactory;
import org.apache.pluto.portalImpl.servlet.ServletResponseFactory;

import com.univ.portail.service.factorymanager.FactoryManager;

// TODO: Auto-generated Javadoc
/**
 * The Class ServletObjectAccess.
 */
public class ServletObjectAccess {

	/**
	 * Gets the servlet request.
	 * 
	 * @param request
	 *            the request
	 * @param portletWindow
	 *            the portlet window
	 * 
	 * @return the servlet request
	 */
	public static HttpServletRequest getServletRequest(HttpServletRequest request, PortletWindow portletWindow) {
		return getRequestFactory().getServletRequest(request, portletWindow);
	}

	/**
	 * Gets the servlet response.
	 * 
	 * @param response
	 *            the response
	 * 
	 * @return the servlet response
	 */
	public static HttpServletResponse getServletResponse(HttpServletResponse response) {
		return getResponseFactory().getServletResponse(response);
	}

	/**
	 * Gets the stored servlet response.
	 * 
	 * @param response
	 *            the response
	 * @param writer
	 *            the writer
	 * 
	 * @return the stored servlet response
	 */
	public static HttpServletResponse getStoredServletResponse(HttpServletResponse response, PrintWriter writer) {
		return getResponseFactory().getStoredServletResponse(response, writer);
	}

	/**
	 * Gets the request factory.
	 * 
	 * @return the request factory
	 */
	private static ServletRequestFactory getRequestFactory() {
		return (ServletRequestFactory) FactoryManager.getFactory(javax.servlet.http.HttpServletRequest.class);
	}

	/**
	 * Gets the response factory.
	 * 
	 * @return the response factory
	 */
	private static ServletResponseFactory getResponseFactory() {
		return (ServletResponseFactory) FactoryManager.getFactory(javax.servlet.http.HttpServletResponse.class);
	}
}
